/*
 * $Id: memory.h,v 1.4 2003/12/01 07:35:53 troth Exp $
 *
 ****************************************************************************
 *
 * simulavr - A simulator for the Atmel AVR family of microcontrollers.
 * Copyright (C) 2001, 2002, 2003  Theodore A. Roth
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 ****************************************************************************
 */

#ifndef SIM_MEMORY_H
#define SIM_MEMORY_H

/****************************************************************************\
 *
 * Memory(AvrClass) Definition.
 *
\****************************************************************************/

typedef struct _Memory Memory;

struct _Memory
{
    AvrClass parent;
    DList *dev;                 /* A linked list of virtual devices */
};

extern Memory *mem_new (void);
extern void mem_construct (Memory *mem);
extern void mem_destroy (void *mem);

extern void mem_attach (Memory *mem, VDevice *dev);
extern VDevice *mem_get_vdevice_by_addr (Memory *mem, int addr);
extern VDevice *mem_get_vdevice_by_name (Memory *mem, char *name);

extern uint8_t mem_read (Memory *mem, int addr);
extern void mem_write (Memory *mem, int addr, uint8_t val);
extern void mem_reset (Memory *mem);

extern void mem_io_fetch (Memory *mem, int addr, uint8_t * val, char *buf,
                          int bufsiz);
extern void mem_dump_core (Memory *mem, FILE * f_core);

#endif /* SIM_MEMORY_H */
