/*
 * Decompiled with CFR 0.152.
 */
package org.ahunt.simpleRowLog.gui.simpleGUI;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Date;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import org.ahunt.simpleRowLog.gui.simpleGUI.OutingDialog;

public class SuggestiveTextField
extends JTextField
implements DocumentListener,
MenuKeyListener,
ActionListener {
    private Point popupLocation;
    private JPopupMenu popup = new JPopupMenu();
    private Container container;
    private int entryNumber;
    private boolean mustBeFilled;
    private boolean validEntry;
    private boolean isFilled;
    private String[] options;

    public SuggestiveTextField(Container container, boolean mustBeFilled, String[] options, int columns) {
        super(columns);
        this.container = container;
        this.mustBeFilled = mustBeFilled;
        this.options = options;
        this.getDocument().addDocumentListener(this);
        this.popup.addMenuKeyListener(this);
    }

    private void calculateLocation() {
        Point textLocation = this.getLocation();
        Dimension textSize = this.getSize();
        Insets insets = this.container.getInsets();
        System.out.println("Inset" + insets);
        this.popupLocation = this.container.getClass().getName().equals(OutingDialog.class.getName()) ? new Point(textLocation.x + insets.left, textLocation.y + textSize.height + insets.top) : new Point(textLocation.x, textLocation.y + textSize.height);
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        if (this.popupLocation == null) {
            this.calculateLocation();
        }
        this.popup.removeAll();
        String entryText = this.getText();
        int entryLength = entryText.length();
        this.validEntry = false;
        for (String s : this.options) {
            if (s.length() >= entryLength && s.substring(0, entryLength).compareToIgnoreCase(entryText) == 0) {
                JMenuItem jm = new JMenuItem(s);
                jm.addActionListener(this);
                this.popup.add(jm);
            }
            if (s.compareToIgnoreCase(entryText) == 0 | (entryLength == 0 && !this.mustBeFilled)) {
                this.validEntry = true;
            }
            if (s.compareToIgnoreCase(entryText) != 0 || s.equals(entryText)) continue;
            this.setText(s);
        }
        this.isFilled = entryLength > 0;
        if (this.validEntry) {
            this.setBackground(Color.WHITE);
        } else if (entryLength == 0 && !this.mustBeFilled) {
            this.setBackground(Color.WHITE);
        } else if (entryLength == 0 && this.mustBeFilled) {
            this.setBackground(Color.YELLOW);
        } else {
            this.setBackground(Color.RED);
        }
        if (this.popup.getComponentCount() != 0 && this.container.isShowing()) {
            this.popup.show(this.container, this.popupLocation.x, this.popupLocation.y);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.changedUpdate(arg0);
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.changedUpdate(arg0);
    }

    @Override
    public void menuKeyPressed(MenuKeyEvent arg0) {
        if (arg0.getKeyCode() == 10 | arg0.getKeyCode() == 9 && this.popup.getComponentCount() == 1) {
            JMenuItem c = (JMenuItem)this.popup.getComponents()[0];
            this.setText(c.getText());
            this.popup.setEnabled(false);
            this.popup.setVisible(false);
            this.dispatchEvent(new KeyEvent(this, 401, new Date().getTime(), 0, 9, '\uffff'));
        } else if (arg0.getKeyCode() == 8 | arg0.getKeyCode() == 9) {
            this.menuKeyTyped(arg0);
        }
    }

    @Override
    public void menuKeyReleased(MenuKeyEvent arg0) {
    }

    @Override
    public void menuKeyTyped(MenuKeyEvent arg0) {
        this.popup.setEnabled(false);
        this.popup.setVisible(false);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(this, arg0);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.setText(arg0.getActionCommand());
        this.popup.setEnabled(false);
        this.popup.setVisible(false);
        this.dispatchEvent(new KeyEvent(this, 401, new Date().getTime(), 0, 9, '\uffff'));
    }

    public void setOptions(String[] options) {
        this.options = options;
    }
}

