/*
 * Decompiled with CFR 0.152.
 */
package org.ahunt.simpleRowLog.common;

import java.util.ArrayList;

public class AdminPermissionList {
    private ArrayList<String> permissionsList = new ArrayList();
    private String username;

    public AdminPermissionList(String username) {
        this.username = username;
    }

    public AdminPermissionList(String username, String[] permissions) {
        new AdminPermissionList(username);
        this.addPermissions(permissions);
    }

    public void addPermissions(String[] permissions) {
        for (String permission : permissions) {
            this.addPermission(permission);
        }
    }

    public void removePermissions(String[] permissions) {
        for (String permission : permissions) {
            this.removePermission(permission);
        }
    }

    public void clearAllPermissions() {
        this.permissionsList.clear();
    }

    public void addPermission(String permission) {
        if (!this.isPermissionSet(permission)) {
            this.permissionsList.add(permission);
        }
    }

    public boolean isPermissionSet(String permission) {
        return this.permissionsList.contains(permission);
    }

    public boolean removePermission(String permission) {
        return this.permissionsList.remove(permission);
    }

    public String[] getAllPermissions() {
        return this.permissionsList.toArray(new String[this.permissionsList.size()]);
    }
}

