/************************************************************************
 * SGA - A C++ library to help develop Simple Genetic Algorithms        *
 * Copyright (C) 2005 Dorival M. Pedroso                                *
 *                                                                      *
 * This program is free software: you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation, either version 3 of the License, or    *
 * any later version.                                                   *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program. If not, see <http://www.gnu.org/licenses/>  *
 ************************************************************************/

// STL
#include <iostream>

// SGA
#include "random.h"

using std::cout;
using std::endl;

int main(int argc, char **argv)
{
	// Constats
	const int ni = 100; // Number of integers
	const int nf = 100; // Number of flips

	// Variables
	int freqi[] = {0,0,0,0,0,0,0,0,0,0,0}; // Frequencies of integers
	int freqf[] = {0,0};                   // Frequencies of flips

	// Seed
	if (argc>1) Rnd::Init(atoi(argv[1]));
	else        Rnd::Init(1234);

	// Generate
	for (int i=0; i<ni; ++i)
	{
		switch (Rnd::T<uint32_t>::Gen(0,10))
		{
			case  0: freqi[ 0]++; break;
			case  1: freqi[ 1]++; break;
			case  2: freqi[ 2]++; break;
			case  3: freqi[ 3]++; break;
			case  4: freqi[ 4]++; break;
			case  5: freqi[ 5]++; break;
			case  6: freqi[ 6]++; break;
			case  7: freqi[ 7]++; break;
			case  8: freqi[ 8]++; break;
			case  9: freqi[ 9]++; break;
			case 10: freqi[10]++; break;
		}
	}
	for (int i=0; i<nf; ++i)
	{
		if (Rnd::Flip(0.5)) freqf[0]++;
		else                freqf[1]++;
	}

	// Shuffle
	int list[6] = {0,1,2,3,4,5};
	Rnd::Shuffle(6, list);

	// Output
	cout << "Integers:" << endl;
	cout << "  freq[ 0] = " << freqi[ 0] << " : "; for (int i=0; i<freqi[ 0]; ++i) cout<<"*"; cout<<endl;
	cout << "  freq[ 1] = " << freqi[ 1] << " : "; for (int i=0; i<freqi[ 1]; ++i) cout<<"*"; cout<<endl;
	cout << "  freq[ 2] = " << freqi[ 2] << " : "; for (int i=0; i<freqi[ 2]; ++i) cout<<"*"; cout<<endl;
	cout << "  freq[ 3] = " << freqi[ 3] << " : "; for (int i=0; i<freqi[ 3]; ++i) cout<<"*"; cout<<endl;
	cout << "  freq[ 4] = " << freqi[ 4] << " : "; for (int i=0; i<freqi[ 4]; ++i) cout<<"*"; cout<<endl;
	cout << "  freq[ 5] = " << freqi[ 5] << " : "; for (int i=0; i<freqi[ 5]; ++i) cout<<"*"; cout<<endl;
	cout << "  freq[ 6] = " << freqi[ 6] << " : "; for (int i=0; i<freqi[ 6]; ++i) cout<<"*"; cout<<endl;
	cout << "  freq[ 7] = " << freqi[ 7] << " : "; for (int i=0; i<freqi[ 7]; ++i) cout<<"*"; cout<<endl;
	cout << "  freq[ 8] = " << freqi[ 8] << " : "; for (int i=0; i<freqi[ 8]; ++i) cout<<"*"; cout<<endl;
	cout << "  freq[ 9] = " << freqi[ 9] << " : "; for (int i=0; i<freqi[ 9]; ++i) cout<<"*"; cout<<endl;
	cout << "  freq[10] = " << freqi[10] << " : "; for (int i=0; i<freqi[10]; ++i) cout<<"*"; cout<<endl<<endl;
	cout << "Flips:" << endl;
	cout << "  freq[true]  = " << freqf[0] << " : "; for (int i=0; i<freqf[0]; ++i) cout<<"*"; cout<<endl;
	cout << "  freq[false] = " << freqf[1] << " : "; for (int i=0; i<freqf[1]; ++i) cout<<"*"; cout<<endl<<endl;
	cout << "Shuffle:" << endl;
	cout << "  "; for (int i=0; i<6; ++i) cout << list[i] << " "; cout << endl;

	// End
	return 0;
}

// vim:fdm=marker
