/************************************************************************
 * SGA - A C++ library to help develop Simple Genetic Algorithms        *
 * Copyright (C) 2005 Dorival M. Pedroso                                *
 *                                                                      *
 * This program is free software: you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation, either version 3 of the License, or    *
 * any later version.                                                   *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program. If not, see <http://www.gnu.org/licenses/>  *
 ************************************************************************/

// FLTK
#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Output.H>

// MainWindow
class MainWindow : public Fl_Window
{
public:
	MainWindow(int w, int h, const char * Title);
	~MainWindow() {}
	Fl_Button * copy;
	Fl_Button * quit;
	Fl_Input  * inp;
	Fl_Output * out;

private:
	static void cb_copy(Fl_Widget*, void*);
	inline void cb_copy_i();

	static void cb_quit(Fl_Widget*, void*);
	inline void cb_quit_i();

}; // class MainWindow


/////////////////////////////////////////////////////////////////////////////////////////// Implementation /////


inline MainWindow::MainWindow(int w, int h, const char * Title) // {{{
	: Fl_Window (w,h,Title)
{
	begin();
		copy = new Fl_Button( 10, 150, 70, 30, "C&opy");
		copy->callback( cb_copy, this );

		quit = new Fl_Button(100, 150, 70, 30, "&Quit");
		quit->callback(cb_quit, this);

		inp = new Fl_Input(50, 50, 140, 30, "Input:");
		out = new Fl_Output(50, 100, 140, 30, "Output:");
	end();
	resizable(this);
	show();
} // }}}

inline void MainWindow::cb_copy(Fl_Widget* o, void* v) // {{{
{
	((MainWindow*)v)->cb_copy_i();
} // }}}

inline void MainWindow::cb_copy_i() // {{{
{
	out->value(inp->value()); 
} // }}}

inline void MainWindow::cb_quit(Fl_Widget* , void* v) // {{{
{
	((MainWindow*)v)->cb_quit_i();
} // }}}

inline void MainWindow::cb_quit_i() // {{{
{
	hide();
} // }}}


////////////////////////////////////////////////////////////////////////////////////////////////////  main /////


int main()
{
	MainWindow win(300,200,"MainWindow");
	return Fl::run();
}

// vim:fdm=marker
