/************************************************************************
 * SGA - A C++ library to help develop Simple Genetic Algorithms        *
 * Copyright (C) 2005 Dorival M. Pedroso                                *
 *                                                                      *
 * This program is free software: you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation, either version 3 of the License, or    *
 * any later version.                                                   *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program. If not, see <http://www.gnu.org/licenses/>  *
 ************************************************************************/

// STL
#include <stdio.h>
#include <string.h>
#include <emmintrin.h>
#include <inttypes.h>

// 128-bit data structure (for SSE2 only)
union W128_T {
	__m128i  si;
	__m128d  sd;
	uint64_t u[2];
	uint32_t u32[4];
	double   d[2];
};

// SGA
#include "random.h"

extern "C" void fill_array_close1_open2(double array[], int size);

int main(int argc, char* argv[])
{
	const int NUM_RANDS = 50000;
	W128_T dummy[NUM_RANDS / 2 + 1];

	int i;
	union W64_T { uint64_t u; double d; };
	union W64_T *array = (union W64_T *)dummy;
	union W64_T r;

	printf("generated randoms [1, 2)\n");
	dinit_gen_rand(1234);
	fill_array_close1_open2(&array[0].d, 5000);
	dinit_gen_rand(1234);
	for (i = 0; i < 5000; i++)
	{
		r.d = genrand_close1_open2();
		if (r.d != array[i].d)
		{
			printf("\n[1, 2) mismatch\n");
			exit(1);
		}
		if (i < 1000)
		{
			printf("%1.20lf ", array[i].d);
			if (i % 3 == 2) printf("\n");
		}
	}
	printf("\n");
}
