/************************************************************************
 * SGA - A C++ library to help develop Simple Genetic Algorithms        *
 * Copyright (C) 2005 Dorival M. Pedroso                                *
 *                                                                      *
 * This program is free software: you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation, either version 3 of the License, or    *
 * any later version.                                                   *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program. If not, see <http://www.gnu.org/licenses/>  *
 ************************************************************************/

// Triangle
extern "C"
{
	#define REAL double
	#define ANSI_DECLARATORS
	#define VOID int
	  #include "triangle.h"
	#undef REAL
	#undef ANSI_DECLARATORS
	#undef VOID
}

/** Wrapper to the Triangle IO structure. */
class TriangleIO
{
public:
	/** Initialize all members of triangulateio structure. */
	TriangleIO(unsigned int nPoints=0)
	{ // {{{

		// Points
		if (nPoints>0) _tio.pointlist = (double*)malloc(nPoints*2*sizeof(double));
		else           _tio.pointlist = NULL;
		_tio.pointattributelist       = NULL;
		_tio.pointmarkerlist          = NULL;
		_tio.numberofpoints           = nPoints;
		_tio.numberofpointattributes  = 0;

		// Triangles
		_tio.trianglelist               = NULL;
		_tio.triangleattributelist      = NULL;
		_tio.trianglearealist           = NULL;
		_tio.neighborlist               = NULL;
		_tio.numberoftriangles          = 0;
		_tio.numberofcorners            = 0;
		_tio.numberoftriangleattributes = 0;

		// Segments
		_tio.segmentlist       = NULL;
		_tio.segmentmarkerlist = NULL;
		_tio.numberofsegments  = 0;

		// Holes
		_tio.holelist      = NULL;
		_tio.numberofholes = 0;

		// Regions
		_tio.regionlist      = NULL;
		_tio.numberofregions = 0;

		// Edges
		_tio.edgelist       = NULL;
		_tio.edgemarkerlist = NULL;
		_tio.normlist       = NULL;
		_tio.numberofedges  = 0;

	} // }}}

	/** Destructor. */
	~TriangleIO()
	{ // {{{

		// Points
		if (_tio.pointlist          != NULL) free(_tio.pointlist);
		if (_tio.pointattributelist != NULL) free(_tio.pointattributelist);
		if (_tio.pointmarkerlist    != NULL) free(_tio.pointmarkerlist);

		// Triangles
		if (_tio.trianglelist          != NULL) free(_tio.trianglelist);
		if (_tio.triangleattributelist != NULL) free(_tio.triangleattributelist);
		if (_tio.trianglearealist      != NULL) free(_tio.trianglearealist);
		if (_tio.neighborlist          != NULL) free(_tio.neighborlist);

		// Segments
		if (_tio.segmentlist       != NULL) free(_tio.segmentlist);
		if (_tio.segmentmarkerlist != NULL) free(_tio.segmentmarkerlist);

		// Holes
		if (_tio.holelist != NULL) free(_tio.holelist);

		// Regions
		if (_tio.regionlist != NULL) free(_tio.regionlist);

		// Edges
		if (_tio.edgelist       != NULL) free(_tio.edgelist);
		if (_tio.edgemarkerlist != NULL) free(_tio.edgemarkerlist);
		if (_tio.normlist       != NULL) free(_tio.normlist);

	} // }}}

	// Methods
	inline triangulateio       & R()       { return  _tio; } ///< Returns a Reference
	inline triangulateio       * P()       { return &_tio; } ///< Returns a Pointer
	inline triangulateio const & R() const { return  _tio; } ///< Returns a Reference (read-only)
	inline triangulateio const * P() const { return &_tio; } ///< Returns a Pointer (read-only)

	/** Output triangles */
	inline void OutTriangles (std::ostringstream & oss)
	{ // {{{
		if (_tio.trianglelist!=NULL)
		{
			for (int i=0; i <_tio.numberoftriangles; i++)
			{
				for (int j=0; j<_tio.numberofcorners; j++)
					oss << _tio.trianglelist[i*_tio.numberofcorners+j] << " ";
				oss << "\n";
			}
		}
		else oss << "trianglelist is NULL\n";
	} // }}}

	/** Output edges */
	inline void OutEdges (std::ostringstream & oss)
	{ // {{{
		if (_tio.edgelist!=NULL)
		{
			for (int i=0; i<_tio.numberofedges; i++)
			{
				for (int j=0; j<2; j++)
					oss << _tio.edgelist[i*2+j] << " ";
				oss << "\n";
			}
		}
		else oss << "edgelist is NULL\n";
	} // }}}

private:
	// Data
	triangulateio _tio; ///< Triangle's internal IO structure

}; // class TriangleIO

// vim:fdm=marker
