/************************************************************************
 * SGA - A C++ library to help develop Simple Genetic Algorithms        *
 * Copyright (C) 2005 Dorival M. Pedroso                                *
 *                                                                      *
 * This program is free software: you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation, either version 3 of the License, or    *
 * any later version.                                                   *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program. If not, see <http://www.gnu.org/licenses/>  *
 ************************************************************************/

#ifndef SGA_NUMSTREAMS_H
#define SGA_NUMSTREAMS_H

// STL
#include <iostream>
#include <iomanip>

namespace SGA
{

/** Number format via STL streams. */
struct NumStream
{
	bool BoolAlpha;  ///< Format output as a boolean?
	bool Integer;    ///< Format output as an integer?
	bool Scientific; ///< Format output as a scientific number?
	int  Width;      ///< Width of the output
	int  Precision;  ///< Precision for floating point numbers
};

//                   bool  integ  scien   w  p
NumStream _a    = {  true, false, false,  0, 0 }; ///< Boolean
NumStream _3    = { false,  true, false,  3, 0 }; ///< Integer
NumStream _4    = { false,  true, false,  4, 0 }; ///< Integer
NumStream _6    = { false,  true, false,  6, 0 }; ///< Integer
NumStream _8    = { false,  true, false,  8, 0 }; ///< Integer
NumStream _3s   = { false, false,  true,  0, 3 }; ///< Scientific
NumStream _8s   = { false, false,  true,  0, 8 }; ///< Scientific
NumStream _6_3  = { false, false, false,  6, 3 }; ///< General
NumStream _12_6 = { false, false, false, 12, 6 }; ///< General

/** Format the output. */
std::ostream & operator<< (std::ostream & os, NumStream const & NS)
{
	     if (NS.BoolAlpha)  { os<<" "<<std::setw(6)<<std::boolalpha; return os; }
	else if (NS.Integer)    { os<<" "<<std::setw(NS.Width); return os; }
	else if (NS.Scientific) { os<<" "<<std::setw(NS.Precision+9)<<std::scientific<<std::setprecision(NS.Precision); return os; } // add 9
	else                    { os<<" "<<std::setw(NS.Width+1)<<std::fixed<<std::setprecision(NS.Precision); return os; } // add 1 (for sign)
}

}; // namespace SGA

#endif // SGA_NUMSTREAMS_H
