/************************************************************************
 * SGA - A C++ library to help develop Simple Genetic Algorithms        *
 * Copyright (C) 2005 Dorival M. Pedroso                                *
 *                                                                      *
 * This program is free software: you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation, either version 3 of the License, or    *
 * any later version.                                                   *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program. If not, see <http://www.gnu.org/licenses/>  *
 ************************************************************************/

#ifndef SGA_MPITRAITS_H
#define SGA_MPITRAITS_H

// OpenMPI
#include "mpi.h"

namespace SGA
{

/** %MPITraits let us bind MPI types to C++ types. */
template <class T> class MPITraits
{
public:
	/** return the MPI data type of the template argument */
	static MPI::Datatype Type();
};

/** Binds MPI::UNSIGNED to uint32_t */
template <> class MPITraits<uint32_t>
{
public:
	/** Return the MPI data type correspondent to uint32_t. */
	static MPI::Datatype Type() { return MPI::UNSIGNED; }
};

/** Binds MPI::DOUBLE to double */
template <> class MPITraits<double>
{
public:
	/** Return the MPI data type correspondent to double. */
	static MPI::Datatype Type() { return MPI::DOUBLE; }
};

/** Binds MPI::LONG to long */
template <> class MPITraits<long>
{
public:
	/** Return the MPI data type correspondent to long. */
	static MPI::Datatype Type() { return MPI::LONG; }
};

}; // namespace SGA

#endif // SGA_MPITRAITS_H
