## Script (Python) "Add Resources"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=REQUEST,RESPONSE
##title=Adding Resources
##

username = REQUEST['username']

title = REQUEST['title']
description = REQUEST['description']

copyright = REQUEST['copyright']
if copyright == '':
    copyright = "Not Specified"

source = REQUEST['source']
if source == '':
    source = "Not Specified"

license = REQUEST['license']

if license == '':
    license = "Not Specified"

fp = context.REQUEST['fileId']

filename = fp.filename

fileres = []
fileres = context.getFileInfo(fp)


filesize= fileres[0]
extn = fileres[1]

imagaEXT = ['jpeg','jpg','tiff','png','gif','bmp','ai','pcx']
audioEXT = ['aa','aa3','acd','acc','au','amr','cdr','cda','mid','midi','mp3','mp2','mpa','swa','wave','wav','xmi','ogg','ram']
videoEXT = ['aac','ac3','mpeg','mpg','mp4','ogm','omf','rm']

instanceof = []

if extn in imagaEXT:
    instanceof.append('image')
elif extn in audioEXT:
    instanceof.append('audio')
elif extn in videoEXT:
    instanceof.append('video')
else:
    instanceof.append('otherResources')

"""
	Calculating nodeid
"""

rs_nid = fileres[2]

flag = context.gnowql.isnidExists(str(rs_nid))

if flag == 1:
    context.REQUEST.RESPONSE.redirect( context.portal_url() + '/filemanagermsg' )
    return "File Exists"


"""
	Getting userid from the username
"""

uid = context.gnowql.getUserIdfromUsername(username)

"""
	Preparing the dictionary for adding
	the content as an object
"""

dictParameters = {
		'nid':rs_nid,
		'uid':uid,
		'status':'Public',
		'content':'',
		'title':[title],
		'description':description,
		'instanceof':instanceof
		}

context.gnowql.manageAddObject( dictParameters )

"""
	Getting the latest ssid of the Resource Object.
"""

rs_ssid = context.gnowql.getlatestVersion( rs_nid )


"""
         Adding Attributes to resource object
"""

atlst = []

for x in instanceof:
    ssidofot = context.gnowql.getlatestVersion( x )
    atlst = context.gnowql.getinfoFromSSID( ssidofot ,'gbobjecttypes')['attributetypes']

lstofDict =[] 
for y in atlst:
    if context.gnowql.getinfoFromSSID( y ,'gbattributetypes')['nid'] == 'FileName':

        dictParameters = {
            'uid':uid,
            'status':'Public',
            'instanceof':[y],
            'value':filename,
            'subject':rs_ssid
            }

        lstofDict.append(dictParameters)

    if context.gnowql.getinfoFromSSID( y ,'gbattributetypes')['nid'] == 'FileSize':

        dictParameters = {
            'uid':uid,
            'status':'Public',
            'instanceof':[y],
            'value':filesize,
            'subject':rs_ssid
            }

        lstofDict.append(dictParameters)

    if context.gnowql.getinfoFromSSID( y ,'gbattributetypes')['nid'] == 'Copyright':

        dictParameters = {
            'uid':uid,
            'status':'Public',
            'instanceof':[y],
            'value':copyright,
            'subject':rs_ssid
            }

        lstofDict.append(dictParameters)

    if context.gnowql.getinfoFromSSID( y ,'gbattributetypes')['nid'] == 'Source':

        dictParameters = {
            'uid':uid,
            'status':'Public',
            'instanceof':[y],
            'value':source,
            'subject':rs_ssid
            }

        lstofDict.append(dictParameters)

    if context.gnowql.getinfoFromSSID( y ,'gbattributetypes')['nid'] == 'License':

        dictParameters = {
            'uid':uid,
            'status':'Public',
            'instanceof':[y],
            'value':license,
            'subject':rs_ssid
            }
        lstofDict.append(dictParameters)


context.gnowql.manageAddAttribute( lstofDict )

"""
creating file at file system
"""

rs_ssid1 = context.gnowql.getlatestVersion( rs_nid )

filepath = context.gnowql.getinfoFromSSID( rs_ssid1 ,'gbobjects')['uri']
context.createFile(fp,filepath)


context.REQUEST.RESPONSE.redirect( context.portal_url() + '/filemanager' )

# course_ssid = REQUEST['course_ssid']
# context.REQUEST.RESPONSE.redirect( context.portal_url() + '/lessonsview?ssid=' + str(course_ssid) )
