#!/bin/sh

# Process this file with autoconf to produce a configure script.

# Copyright (C) 2013 Henrik Sandklef
#
# This file is part of Searduino
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


read_file()
{
    FILE=$1
    if [ -f ${FILE} ]
    then
	. ${FILE}
    else
	echo "Can't find file: $FILE"
	exit 1
    fi
}

SEARDUINO_PATH=/tmp/hesa/TMP_INSTALL3
SEARDUINO_SHARE=${SEARDUINO_PATH}/share/searduino/
read_file ${SEARDUINO_SHARE}/scripts/settings
read_file ${SEARDUINO_SHARE}/scripts/functions


export PATH=/tmp/hesa/TMP_INSTALL3/bin:${PATH}
export LD_LIBRARY_PATH=/tmp/hesa/TMP_INSTALL3/lib
export JAVA_LIBRARY_PATH=/tmp/hesa/TMP_INSTALL3/lib


java -cp ${JAVA_LIBRARY_PATH}/Searduino.jar:${JAVA_LIBRARY_PATH}/Jearduino.jar\
     -Dsearduino.dir=${SEARDUINO_PATH} \
     -Dsearduino.project.dir=${SEARDUINO_PROJECT_DIR} \
     -Dsearduino.arduinoex.dir=${ARDUINO_INO_EX} \
     -Djava.library.path=${JAVA_LIBRARY_PATH} \
      com.sandklef.jearduino.Jearduino $*
