/*
 * Decompiled with CFR 0.152.
 */
package com.sandklef.jearduino;

import com.sandklef.jearduino.PinEvent;
import com.sandklef.searduino.Searduino;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PinTable
extends JPanel
implements ActionListener,
ChangeListener {
    private Object[][] pins;
    String[] columnNames = new String[]{"Number", "Type", "Mode", "Input", "Value"};
    private int nrPins;
    private final int TABLE_NUMBER_POS = 0;
    private final int TABLE_TYPE_POS = 1;
    private final int TABLE_MODE_POS = 2;
    private final int TABLE_INPUT_POS = 3;
    private final int TABLE_OUTPUT_POS = 4;
    Searduino searduino;
    private int[] pinMode;
    private int[] pinType;
    private PinEvent pe;

    public PinTable(PinEvent pinEvent, Searduino searduino) {
        this.searduino = searduino;
        this.pe = pinEvent;
        this.setBorder(BorderFactory.createTitledBorder("Pins"));
    }

    private int getItemPosFromCombo(JComboBox jComboBox, String string) {
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            if (!jComboBox.getItemAt(i).equals(string)) continue;
            return i;
        }
        return 0;
    }

    public void setTypeInputPin(int n, int n2, boolean bl) {
        if (this.pins == null) {
            return;
        }
        if (!this.searduino.hasGenericPinTypeBoolean(n, n2)) {
            System.out.println("\n\n *** ERROR: Can not set type " + Searduino.getPinType((int)n2) + " on pin " + n + " \n\n");
            return;
        }
        if (bl) {
            if (n2 == 1) {
                JComboBox jComboBox = (JComboBox)this.pins[n][1];
                int n3 = this.getItemPosFromCombo(jComboBox, Searduino.getPinType((int)1));
                jComboBox.setSelectedIndex(n3);
            } else if (n2 == 2) {
                JComboBox jComboBox = (JComboBox)this.pins[n][1];
                int n4 = this.getItemPosFromCombo(jComboBox, Searduino.getPinType((int)2));
                jComboBox.setSelectedIndex(n4);
            } else if (n2 == 3) {
                JComboBox jComboBox = (JComboBox)this.pins[n][1];
                int n5 = this.getItemPosFromCombo(jComboBox, Searduino.getPinType((int)3));
                jComboBox.setSelectedIndex(n5);
            }
        } else if (n2 == 1) {
            this.setDigitalInputPin(n);
        } else if (n2 == 2) {
            this.setAnalogInputPin(n);
        } else if (n2 == 3) {
            this.setPwmPin(n);
        }
    }

    public void setAnalogInputPin(int n) {
        int n2 = n * 5 + 3 + 1;
        if (this.pins == null) {
            return;
        }
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0, 0, 1024, 10);
        JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        jSpinner.setVisible(true);
        jSpinner.setEnabled(true);
        jSpinner.addChangeListener(this);
        if (this.pins[n][3] != null) {
            this.remove(n2);
        }
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException);
        }
        this.add((Component)jSpinner, n2);
        ((JLabel)this.pins[n][4]).setVisible(false);
        this.pins[n][3] = jSpinner;
        this.pinType[n] = 2;
        jSpinner.repaint();
        this.revalidate();
        this.repaint();
    }

    public void setDigitalInputPin(int n) {
        int n2 = n * 5 + 3 + 1;
        if (this.pins == null) {
            return;
        }
        JToggleButton jToggleButton = new JToggleButton("");
        jToggleButton.addActionListener(this);
        jToggleButton.setEnabled(true);
        jToggleButton.setVisible(true);
        if (this.pins[n][3] != null) {
            this.remove(n2);
        }
        this.add((Component)jToggleButton, n2);
        ((JLabel)this.pins[n][4]).setVisible(false);
        this.pins[n][3] = jToggleButton;
        this.pinType[n] = 1;
    }

    public void setPwmPin(int n) {
        int n2 = n * 5 + 3 + 1;
        JLabel jLabel = new JLabel("");
        jLabel.setEnabled(true);
        jLabel.setVisible(true);
        if (this.pins[n][3] != null) {
            this.remove(n2);
        }
        this.add((Component)jLabel, n2);
        ((JLabel)this.pins[n][2]).setText("Output");
        this.pins[n][3] = jLabel;
        ((JLabel)this.pins[n][4]).setVisible(false);
        this.pinType[n] = 3;
    }

    private void handlePinActionPerformed(ActionEvent actionEvent) {
        for (int n = 1; n < this.nrPins; n = (int)((char)(n + 1))) {
            if (actionEvent.getSource() != this.pins[n][3]) continue;
            if (((JToggleButton)this.pins[n][3]).isSelected()) {
                this.pe.inputValueEvent(n, 1);
                continue;
            }
            this.pe.inputValueEvent(n, 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("comboBoxChanged")) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            String string2 = (String)jComboBox.getSelectedItem();
            int n = Searduino.getPinType((String)string2);
            for (int i = 0; i < this.nrPins; ++i) {
                if (this.pins[i][1] != jComboBox) continue;
                this.setTypeInputPin(i, n, false);
            }
        } else {
            this.handlePinActionPerformed(actionEvent);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        for (int i = 1; i < this.nrPins; ++i) {
            if (changeEvent.getSource() != this.pins[i][3]) continue;
            this.pe.inputValueEvent(i, (Integer)((JSpinner)this.pins[i][3]).getValue());
        }
    }

    public int getInputPinTypeLocal(int n) {
        return this.pinType[n];
    }

    public void setPinValue(int n, int n2, int n3) {
        ((JLabel)this.pins[n][4]).setVisible(true);
        ((JLabel)this.pins[n][4]).setText("" + n2);
    }

    public void setPinTypeOBSOLETE(int n, int n2) {
        System.out.println("PIN: " + n + "  TYPE: " + n2);
    }

    public void setInputMode(int n) {
        this.setMode(n, 0);
    }

    public void setOutputMode(int n) {
        this.setMode(n, 1);
    }

    public void setMode(int n, int n2) {
        System.out.println("---->SET PIN " + n + " (" + this.pinType[n] + ")  to: " + n2);
        System.out.flush();
        if (n2 == 0) {
            ((JLabel)this.pins[n][2]).setText("INPUT");
            this.pinMode[n] = 0;
            if (this.pinType[n] == 1) {
                ((JToggleButton)this.pins[n][3]).setVisible(true);
            } else if (this.pinType[n] == 2) {
                ((JSpinner)this.pins[n][3]).setVisible(true);
            } else {
                System.out.println("ERROR ---- SET PIN " + n + " (" + this.pinType[n] + ")  to: " + n2);
            }
            ((JLabel)this.pins[n][4]).setVisible(false);
        } else {
            ((JLabel)this.pins[n][2]).setText("OUTPUT");
            this.pinMode[n] = 1;
            if (this.pinType[n] == 1) {
                ((JToggleButton)this.pins[n][3]).setVisible(false);
            } else if (this.pinType[n] == 2) {
                ((JSpinner)this.pins[n][3]).setVisible(true);
            } else {
                System.out.println("ERROR ---- SET PIN " + n + " (" + this.pinType[n] + ")  to: " + n2);
            }
            ((JLabel)this.pins[n][4]).setVisible(true);
        }
        System.out.println("<---- SET PIN " + n + " (" + this.pinType[n] + ")  to: " + n2);
    }

    private void addTypeOnPin(ArrayList arrayList, int n, int n2) {
        if (this.searduino.hasGenericPinTypeBoolean(n, n2)) {
            arrayList.add(Searduino.getPinType((int)n2));
        }
    }

    public void setupPins() {
        int n;
        this.nrPins = n = this.searduino.getNrOfPins();
        this.setLayout(new GridLayout(this.nrPins, 5));
        this.removeAll();
        this.pinMode = new int[this.nrPins];
        this.pinType = new int[this.nrPins];
        this.pins = new Object[this.nrPins][5];
        this.add(new JLabel("Pin"));
        this.add(new JLabel("Type"));
        this.add(new JLabel("Mode"));
        this.add(new JLabel("Ouput"));
        this.add(new JLabel("Input"));
        for (int i = 1; i < this.nrPins; ++i) {
            this.pinMode[i] = 0;
            this.pinType[i] = 0;
            JLabel jLabel = new JLabel("" + i);
            jLabel.setVisible(true);
            this.add(jLabel);
            ArrayList arrayList = new ArrayList();
            this.addTypeOnPin(arrayList, i, 1);
            this.addTypeOnPin(arrayList, i, 3);
            this.addTypeOnPin(arrayList, i, 2);
            JComboBox<Object> jComboBox = new JComboBox<Object>(arrayList.toArray());
            jComboBox.setVisible(true);
            jComboBox.addActionListener(this);
            this.add(jComboBox);
            JLabel jLabel2 = new JLabel("INPUT");
            jLabel2.setVisible(true);
            this.add(jLabel2);
            JLabel jLabel3 = new JLabel("0");
            jLabel3.setVisible(false);
            this.add(jLabel3);
            this.pins[i][1] = jComboBox;
            this.pins[i][0] = jLabel;
            this.pins[i][2] = jLabel2;
            this.pins[i][4] = jLabel3;
            this.setTypeInputPin(i, this.searduino.getCurrentPinType(i), false);
        }
    }
}

