#include "common.h"
#include "wordsearch.h"
#include "words.h"

int main(int argc, char** argv) {
    if(argc != 3) {
	printf("Usage: WORDSEARCH WORDS\n");
	return 0;
    }

    Wordsearch search = readWordsearch(argv[1]);
    
    int numWords;
    char** words = readWords(argv[2], &numWords);

    if(words == NULL) {
	fprintf(stderr, "Failed to read words.\n");
	return 5;
    }

    int i;
    for(i = 0; i < numWords; i++) {
	char* word = words[i];

	int numLocs;

	printf("%s:\n", word);
	Location* locs = solve(search, word, &numLocs);
	printLocs(search, locs, numLocs);
	printf("\n");
    }
}
