#include "common.h"
#include "wordsearch.h"
#include "words.h"


int main(int argc, char** argv) {
    if(argc != 3) {
	printf("Usage: WORDSEARCH WORDS\n");
	return 0;
    }

    Wordsearch search = readWordsearch(argv[1]);

    int numWords;
    char** words = readWords(argv[2], &numWords);

    if(words == NULL) {
	fprintf(stderr, "Failed to read words.\n");
	return 5;
    }

    int i;
    for(i = 0; i < numWords; i++) {
	char* word = words[i];

	int numLocs;
	Location* locs = solve(search, word, &numLocs);
	
	int a;
	for(a = 0; a < numLocs; a++) {
	    printf("%s : (%d,%d) (%d,%d)\n", 
		  word, 
		  locs[a].x1, 
		  locs[a].y1, 
		  locs[a].x2, 
		  locs[a].y2);
	}
    }

    return 0;
}
