/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
/*
 * Created by Vim :-)
 * User: Pierre Dittgen
 * Date: 2 apr. 2004
 */
package fr.gouv.culture.sdx.search.lucene.analysis.tokenizer;

import java.io.Reader;

import org.apache.lucene.analysis.CharTokenizer;


/**
 * Title: LetterOrDigitTokenizer
 * Description: Like org.apache.lucene.analysis.LetterTokenizer but also
 * accept digits
 * Copyright:   Copyright (c) 2004
 * Company:
 * @author Pierre Dittgen
 * @version 1.0
 *
 */
public class LetterOrDigitTokenizer extends CharTokenizer {


    public LetterOrDigitTokenizer(Reader in)
	{
        super(in);
    }

	protected boolean isTokenChar(char c)
	{
		return Character.isLetterOrDigit(c);
	}

}

