/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 5 nov. 2002
 * Time: 11:39:14
 * To change template for new class use
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package fr.gouv.culture.sdx.search.lucene.analysis;

import java.io.Reader;

import org.apache.lucene.analysis.TokenStream;

import fr.gouv.culture.sdx.search.lucene.analysis.filter.ChineseFilter;
import fr.gouv.culture.sdx.search.lucene.analysis.tokenizer.ChineseTokenizer;

/**
 * Title: ChineseAnalyzer
 * Description:
 *   Subclass of org.apache.lucene.analysis.Analyzer
 *   build from a ChineseTokenizer, filtered with ChineseFilter.
 * Copyright:   Copyright (c) 2001
 * Company:
 * @author Yiyi Sun
 * @version 1.0
 * @deprecated use {@link org.apache.lucene.analysis.cn.ChineseAnalyzer} instead
 */
public class Analyzer_cn extends DefaultAnalyzer {

	/**
	 * @see fr.gouv.culture.sdx.search.lucene.analysis.AbstractAnalyzer#getAnalyserType()
	 */
	protected String getAnalyzerType() {
		return Analyzer_cn.ANALYZER_TYPE;
	}
	protected final static String ANALYZER_TYPE="Analyzer_cn";
	
    /**
     * Creates a TokenStream which tokenizes all the text in the provided Reader.
     *
     * @return  A TokenStream build from a ChineseTokenizer filtered with ChineseFilter.
     */
    public final TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new ChineseTokenizer(reader);
        if (stopTable != null)
            result = new ChineseFilter(result, stopTable);
        else
            result = new ChineseFilter(result);

        return result;
    }

}
