/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.framework;

import fr.gouv.culture.sdx.utils.constants.Node;
import org.apache.avalon.framework.component.Component;

/**
 * An SDX framework.
 *
 * <p>
 * There is one framework object per running SDX installation. It is implemented
 * as a Cocoon/Avalon component with this interface and the {@link fr.gouv.culture.sdx.framework.FrameworkImpl FrameworkImpl} class.
 * <p>
 * This framework is loaded when Cocoon starts up.
 */
public interface Framework extends Component {

    String CLASS_NAME_SUFFIX = "Framework";

    interface ConfigurationNode {
        /** The element used define the use of RMI. */
        String RMI = "rmi-registry";
        /** The implied attribute used to define RMI host. */
        String PORT = "port";
        /** The implied attribute used to define RMI port. */
        String HOST = "host";
    }

    /**Build numer of sdx (ie today's date), in the
     * cvs sources, this value should stay at "2004061601"
     *so that the ant task will change it
     */
    public final static String BUILD = "2004061601";

    /**Version number of sdx
     *
     */
    public static final String VERSION = "2.4.1.3";

    public static final String DEFAULT_ENCODING = "UTF-8";


    /** The role name of the framework component. */
    public static final String ROLE = "fr.gouv.culture.sdx.framework.Framework";

    /**The sdx namespace prefix. */
    public static final String SDXNamespacePrefix = Node.Prefix.SDX;

    /**The sdx namespace uri. */
    public static final String SDXNamespaceURI = Node.Uri.SDX;

    /**The xml namespace prefix. */
    public static final String XMLNamespacePrefix = "xml";

    /**The xml namespace uri. */
    public static final String XMLNamespaceURI = "http://www.w3.org/XML/1998/namespace";

    /**The xml:lang attribute name. */
    public static final String ATTRIBUTE_LANG = Node.Name.LANG;

    /** name of the object used in toSAX() methods */
    public static final String TOSAX = "framework";

    /** url encoding no longer used
     * @deprecated Use encoding set in FrameworkImpl from sdx.xconf file
     */
    public static final String URL_ENCODING = "iso-8859-1";


}
