/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.logging;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.Utilities;
import org.apache.avalon.framework.logger.Logger;

public class LoggingUtils {
    public static void logInfo(Logger logger, String s) {
        if (Utilities.checkString(s) && logger != null && logger.isInfoEnabled()) {
            logger.info(s);
        }
    }

    public static void logInfo(Logger logger, int code, String[] arguments) {
        if (null != logger && logger.isInfoEnabled()) {
            logger.info(new SDXException(code, arguments).getMessage());
        }
    }

    public static void logDebug(Logger logger, String s, Exception e) {
        if (logger != null && logger.isDebugEnabled()) {
            if (Utilities.checkString(s)) {
                if (e != null) {
                    logger.debug(s, (Throwable)e);
                } else {
                    logger.debug(s);
                }
            } else if (e != null && e.getMessage() != null & e.fillInStackTrace() != null) {
                logger.debug(e.getMessage(), e.fillInStackTrace());
            }
        }
    }

    public static void logDebug(Logger logger, String s) {
        LoggingUtils.logDebug(logger, s, null);
    }

    public static void logDebug(Logger logger, int code, String[] arguments) {
        if (null != logger && logger.isDebugEnabled()) {
            logger.debug(new SDXException(code, arguments).getMessage());
        }
    }

    public static void logError(Logger logger, String s, Throwable e) {
        if (logger != null && logger.isErrorEnabled()) {
            if (Utilities.checkString(s)) {
                if (e != null) {
                    logger.error(s, e);
                } else {
                    logger.error(s);
                }
            } else if (e != null && e.getMessage() != null & e.fillInStackTrace() != null) {
                logger.error(e.getMessage(), e.fillInStackTrace());
            }
        }
    }

    public static void logError(Logger logger, String s) {
        LoggingUtils.logError(logger, s, null);
    }

    public static void logError(Logger logger, int code, String[] arguments) {
        if (null != logger && logger.isErrorEnabled()) {
            logger.error(new SDXException(code, arguments).getMessage());
        }
    }

    public static void logWarn(Logger logger, String s, Exception e) {
        if (logger != null && logger.isWarnEnabled()) {
            if (Utilities.checkString(s)) {
                if (e != null) {
                    logger.warn(s, (Throwable)e);
                } else {
                    logger.warn(s);
                }
            } else if (e != null) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void logWarn(Logger logger, int code, String[] arguments) {
        if (null != logger && logger.isWarnEnabled()) {
            logger.warn(new SDXException(code, arguments).getMessage());
        }
    }

    public static void logWarn(Logger logger, String s) {
        LoggingUtils.logWarn(logger, s, null);
    }

    public static void logException(Logger logger, Exception e) {
        if (logger != null && logger.isErrorEnabled() && e != null && e.getMessage() != null && e.fillInStackTrace() != null) {
            logger.error(e.getMessage(), e.fillInStackTrace());
        }
    }
}

