/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.queryparser;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.search.lucene.analysis.AnalyzeString;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer;
import fr.gouv.culture.sdx.search.lucene.analysis.DefaultAnalyzer;
import fr.gouv.culture.sdx.search.lucene.analysis.filter.ISOLatin1AccentFilter;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.search.lucene.queryparser.CharStream;
import fr.gouv.culture.sdx.search.lucene.queryparser.DefaultQueryParserConstants;
import fr.gouv.culture.sdx.search.lucene.queryparser.DefaultQueryParserTokenManager;
import fr.gouv.culture.sdx.search.lucene.queryparser.FastCharStream;
import fr.gouv.culture.sdx.search.lucene.queryparser.ParseException;
import fr.gouv.culture.sdx.search.lucene.queryparser.QueryParser;
import fr.gouv.culture.sdx.search.lucene.queryparser.Token;
import fr.gouv.culture.sdx.search.lucene.queryparser.TokenMgrError;
import fr.gouv.culture.sdx.utils.Date;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.UnanalyzedQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.Parameter;

public class DefaultQueryParser
implements QueryParser,
DefaultQueryParserConstants {
    private static final int CONJ_NONE = 0;
    private static final int CONJ_AND = 1;
    private static final int CONJ_OR = 2;
    private static final int MOD_NONE = 0;
    private static final int MOD_NOT = 10;
    private static final int MOD_REQ = 11;
    public static final Operator AND_OPERATOR = Operator.AND;
    public static final Operator OR_OPERATOR = Operator.OR;
    private Operator operator = OR_OPERATOR;
    boolean lowercaseExpandedTerms = true;
    boolean useOldRangeQuery = false;
    boolean allowLeadingWildcard = false;
    public SearchLocations sLocs = null;
    public Analyzer analyzer;
    String field;
    int phraseSlop = 0;
    float fuzzyMinSim = 0.5f;
    int fuzzyPrefixLength = 0;
    Locale locale = Locale.getDefault();
    DateTools.Resolution dateResolution = null;
    Map fieldToDateResolution = null;
    public DefaultQueryParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[27];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public DefaultQueryParser() {
        this(new FastCharStream(new StringReader("")));
    }

    public DefaultQueryParser(String f, Analyzer a) {
        this(new FastCharStream(new StringReader("")));
        this.analyzer = a;
        this.field = f;
    }

    public Query parse(String query) throws ParseException {
        this.ReInit(new FastCharStream(new StringReader(query)));
        try {
            return this.Query(this.field);
        }
        catch (ParseException tme) {
            throw new ParseException("Cannot parse '" + query + "': " + tme.getMessage());
        }
        catch (TokenMgrError tme) {
            throw new ParseException("Cannot parse '" + query + "': " + tme.getMessage());
        }
        catch (BooleanQuery.TooManyClauses tmc) {
            throw new ParseException("Cannot parse '" + query + "': too many boolean clauses");
        }
    }

    public void setOperator(int op) {
        switch (op) {
            case 0: {
                this.operator = Operator.OR;
                break;
            }
            case 1: {
                this.operator = Operator.AND;
                break;
            }
            default: {
                new SDXException("Operator not implemented: " + (Object)((Object)this.operator));
            }
        }
    }

    public int getOperator() {
        if (this.operator == Operator.OR) {
            return 0;
        }
        if (this.operator == Operator.AND) {
            return 1;
        }
        return -1;
    }

    public void setUp(String f, Analyzer a) {
        this.analyzer = a;
        this.field = f;
    }

    public void setUp(Analyzer a, int phraseSlop, int operator) {
        this.analyzer = a;
        this.setPhraseSlop(phraseSlop);
        this.setOperator(operator);
    }

    public void setUp(String f, Analyzer a, int phraseSlop, int operator) {
        this.field = f;
        this.setUp(a, phraseSlop, operator);
    }

    public void setUp(String f, Analyzer a, SearchLocations sl, int phraseSlop, int operator) {
        this.field = f;
        this.sLocs = sl;
        this.setUp(a, phraseSlop, operator);
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public String getField() {
        return this.field;
    }

    public float getFuzzyMinSim() {
        return this.fuzzyMinSim;
    }

    public void setFuzzyMinSim(float fuzzyMinSim) {
        this.fuzzyMinSim = fuzzyMinSim;
    }

    public int getFuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public int getPhraseSlop() {
        return this.phraseSlop;
    }

    public void setAllowLeadingWildcard(boolean allowLeadingWildcard) {
        this.allowLeadingWildcard = allowLeadingWildcard;
    }

    public boolean getAllowLeadingWildcard() {
        return this.allowLeadingWildcard;
    }

    public void setDefaultOperator(Operator op) {
        this.operator = op;
    }

    public Operator getDefaultOperator() {
        return this.operator;
    }

    public void setLowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
        this.lowercaseExpandedTerms = lowercaseExpandedTerms;
    }

    public boolean getLowercaseExpandedTerms() {
        return this.lowercaseExpandedTerms;
    }

    protected Query getUnanalyzedQuery(String field, String queryText) {
        return new UnanalyzedQuery(new Term(field, queryText));
    }

    public void setUseOldRangeQuery(boolean useOldRangeQuery) {
        this.useOldRangeQuery = useOldRangeQuery;
    }

    public boolean getUseOldRangeQuery() {
        return this.useOldRangeQuery;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setDateResolution(DateTools.Resolution dateResolution) {
        this.dateResolution = dateResolution;
    }

    public void setDateResolution(String fieldName, DateTools.Resolution dateResolution) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field cannot be null.");
        }
        if (this.fieldToDateResolution == null) {
            this.fieldToDateResolution = new HashMap();
        }
        this.fieldToDateResolution.put(fieldName, dateResolution);
    }

    public DateTools.Resolution getDateResolution(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field cannot be null.");
        }
        if (this.fieldToDateResolution == null) {
            return this.dateResolution;
        }
        DateTools.Resolution resolution = (DateTools.Resolution)this.fieldToDateResolution.get(fieldName);
        if (resolution == null) {
            resolution = this.dateResolution;
        }
        return resolution;
    }

    protected void addClause(Vector clauses, int conj, int mods, Query q) {
        boolean required;
        boolean prohibited;
        BooleanClause c;
        if (clauses.size() > 0 && conj == 1 && !(c = (BooleanClause)clauses.elementAt(clauses.size() - 1)).isProhibited()) {
            c.setOccur(BooleanClause.Occur.MUST);
        }
        if (clauses.size() > 0 && this.operator == AND_OPERATOR && conj == 2 && !(c = (BooleanClause)clauses.elementAt(clauses.size() - 1)).isProhibited()) {
            c.setOccur(BooleanClause.Occur.SHOULD);
        }
        if (q == null) {
            return;
        }
        if (this.operator == OR_OPERATOR) {
            prohibited = mods == 10;
            boolean bl = required = mods == 11;
            if (conj == 1 && !prohibited) {
                required = true;
            }
        } else {
            prohibited = mods == 10;
            boolean bl = required = !prohibited && conj != 2;
        }
        if (required && !prohibited) {
            clauses.addElement(new BooleanClause(q, BooleanClause.Occur.MUST));
        } else if (!required && !prohibited) {
            clauses.addElement(new BooleanClause(q, BooleanClause.Occur.SHOULD));
        } else if (!required && prohibited) {
            clauses.addElement(new BooleanClause(q, BooleanClause.Occur.MUST_NOT));
        } else {
            throw new RuntimeException("Clause cannot be both required and prohibited");
        }
    }

    protected Query getFieldQuery(String field, String queryText) throws ParseException {
        return this.getFieldQuery(field, this.analyzer, queryText);
    }

    protected Query getFieldQuery(String field, Analyzer analyzer, String queryText) throws ParseException {
        PhraseQuery q;
        org.apache.lucene.analysis.Token t;
        TokenStream source = analyzer.tokenStream(field, new StringReader(queryText));
        Vector<org.apache.lucene.analysis.Token> v = new Vector<org.apache.lucene.analysis.Token>();
        int positionCount = 0;
        boolean severalTokensAtSamePosition = false;
        while (true) {
            try {
                t = source.next();
            }
            catch (IOException e) {
                t = null;
            }
            if (t == null) break;
            v.addElement(t);
            if (t.getPositionIncrement() != 0) {
                positionCount += t.getPositionIncrement();
                continue;
            }
            severalTokensAtSamePosition = true;
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (v.size() == 0) {
            return null;
        }
        if (v.size() == 1) {
            t = (org.apache.lucene.analysis.Token)v.elementAt(0);
            return new TermQuery(new Term(field, t.termText()));
        }
        if (severalTokensAtSamePosition) {
            if (positionCount == 1) {
                q = new BooleanQuery(true);
                for (int i = 0; i < v.size(); ++i) {
                    t = (org.apache.lucene.analysis.Token)v.elementAt(i);
                    TermQuery currentQuery = new TermQuery(new Term(field, t.termText()));
                    q.add((Query)currentQuery, BooleanClause.Occur.SHOULD);
                }
                return q;
            }
            MultiPhraseQuery mpq = new MultiPhraseQuery();
            mpq.setSlop(this.phraseSlop);
            ArrayList<Term> multiTerms = new ArrayList<Term>();
            for (int i = 0; i < v.size(); ++i) {
                t = (org.apache.lucene.analysis.Token)v.elementAt(i);
                if (t.getPositionIncrement() == 1 && multiTerms.size() > 0) {
                    mpq.add(multiTerms.toArray(new Term[0]));
                    multiTerms.clear();
                }
                multiTerms.add(new Term(field, t.termText()));
            }
            mpq.add(multiTerms.toArray(new Term[0]));
            return mpq;
        }
        q = new PhraseQuery();
        q.setSlop(this.phraseSlop);
        for (int i = 0; i < v.size(); ++i) {
            q.add(new Term(field, ((org.apache.lucene.analysis.Token)v.elementAt(i)).termText()));
        }
        return q;
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        Query query = this.getFieldQuery(field, queryText);
        if (query instanceof PhraseQuery) {
            ((PhraseQuery)query).setSlop(slop);
        }
        if (query instanceof MultiPhraseQuery) {
            ((MultiPhraseQuery)query).setSlop(slop);
        }
        return query;
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        if (this.lowercaseExpandedTerms) {
            part1 = part1.toLowerCase();
            part2 = part2.toLowerCase();
        }
        try {
            java.util.Date d1 = Date.parseDate(part1);
            java.util.Date d2 = Date.parseDate(part2);
            part1 = DateField.dateToString(d1);
            part2 = DateField.dateToString(d2);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.useOldRangeQuery) {
            return new RangeQuery(new Term(field, part1), new Term(field, part2), inclusive);
        }
        return new ConstantScoreRangeQuery(field, part1, part2, inclusive, inclusive);
    }

    protected Query getBooleanQuery(Vector clauses) throws ParseException {
        return this.getBooleanQuery(clauses, false);
    }

    protected Query getBooleanQuery(Vector clauses, boolean disableCoord) throws ParseException {
        BooleanQuery query = new BooleanQuery(disableCoord);
        for (int i = 0; i < clauses.size(); ++i) {
            query.add((BooleanClause)clauses.elementAt(i));
        }
        return query;
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if ("*".equals(field) && "*".equals(termStr)) {
            return new MatchAllDocsQuery();
        }
        if (!this.allowLeadingWildcard && (termStr.startsWith("*") || termStr.startsWith("?"))) {
            throw new ParseException("'*' or '?' not allowed as first character in WildcardQuery");
        }
        if (this.lowercaseExpandedTerms) {
            termStr = ISOLatin1AccentFilter.removeAccents(termStr.toLowerCase());
        }
        Term t = new Term(field, termStr);
        return new WildcardQuery(t);
    }

    protected Query getWildcardQuery(String field, Analyzer analyzer, String termStr) throws ParseException {
        String _termStr;
        block4: {
            if ("*".equals(field) && "*".equals(termStr)) {
                return new MatchAllDocsQuery();
            }
            if (!this.allowLeadingWildcard && (termStr.startsWith("*") || termStr.startsWith("?"))) {
                throw new ParseException("'*' or '?' not allowed as first character in WildcardQuery");
            }
            _termStr = termStr;
            try {
                _termStr = AnalyzeString.getAnalyzedString(termStr, analyzer.getClass().getName(), "");
            }
            catch (Exception e) {
                if (!this.lowercaseExpandedTerms) break block4;
                _termStr = ISOLatin1AccentFilter.removeAccents(termStr.toLowerCase());
            }
        }
        Term t = new Term(field, _termStr);
        return new WildcardQuery(t);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (!this.allowLeadingWildcard && termStr.startsWith("*")) {
            throw new ParseException("'*' not allowed as first character in PrefixQuery");
        }
        if (this.lowercaseExpandedTerms) {
            termStr = ISOLatin1AccentFilter.removeAccents(termStr.toLowerCase());
        }
        Term t = new Term(field, termStr);
        return new PrefixQuery(t);
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        if (this.lowercaseExpandedTerms) {
            termStr = termStr.toLowerCase();
        }
        Term t = new Term(field, termStr);
        return new FuzzyQuery(t, minSimilarity, this.fuzzyPrefixLength);
    }

    private String discardEscapeChar(String input) throws ParseException {
        char[] output = new char[input.length()];
        int length = 0;
        boolean lastCharWasEscapeChar = false;
        int codePointMultiplier = 0;
        int codePoint = 0;
        for (int i = 0; i < input.length(); ++i) {
            char curChar = input.charAt(i);
            if (codePointMultiplier > 0) {
                codePoint += DefaultQueryParser.hexToInt(curChar) * codePointMultiplier;
                if ((codePointMultiplier >>>= 4) != 0) continue;
                output[length++] = (char)codePoint;
                codePoint = 0;
                continue;
            }
            if (lastCharWasEscapeChar) {
                if (curChar == 'u') {
                    codePointMultiplier = 4096;
                } else {
                    output[length] = curChar;
                    ++length;
                }
                lastCharWasEscapeChar = false;
                continue;
            }
            if (curChar == '\\') {
                lastCharWasEscapeChar = true;
                continue;
            }
            output[length] = curChar;
            ++length;
        }
        if (codePointMultiplier > 0) {
            throw new ParseException("Truncated unicode escape sequence.");
        }
        if (lastCharWasEscapeChar) {
            throw new ParseException("Term can not end with escape character.");
        }
        return new String(output, 0, length);
    }

    private static final int hexToInt(char c) throws ParseException {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new ParseException("None-hex character in unicode escape sequence: " + c);
    }

    public static String escape(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: java org.apache.lucene.queryParser.QueryParser <input>");
            System.exit(0);
        }
        DefaultQueryParser qp = new DefaultQueryParser("field", new DefaultAnalyzer());
        Query q = qp.parse(args[0]);
        System.out.println(q.toString("field"));
    }

    public final int Conjunction() throws ParseException {
        int ret = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        ret = 1;
                        break block0;
                    }
                    case 8: {
                        this.jj_consume_token(8);
                        ret = 2;
                        break block0;
                    }
                }
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        return ret;
    }

    public final int Modifiers() throws ParseException {
        int ret = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: {
                        this.jj_consume_token(10);
                        ret = 11;
                        break block0;
                    }
                    case 11: {
                        this.jj_consume_token(11);
                        ret = 10;
                        break block0;
                    }
                    case 9: {
                        this.jj_consume_token(9);
                        ret = 10;
                        break block0;
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        return ret;
    }

    public final Query Query(String field) throws ParseException {
        Vector clauses = new Vector();
        Query firstQuery = null;
        int mods = this.Modifiers();
        Query q = this.Clause(field);
        this.addClause(clauses, 0, mods, q);
        if (mods == 0) {
            firstQuery = q;
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            int conj = this.Conjunction();
            mods = this.Modifiers();
            q = this.Clause(field);
            this.addClause(clauses, conj, mods, q);
        }
        if (clauses.size() == 1 && firstQuery != null) {
            return firstQuery;
        }
        return this.getBooleanQuery(clauses);
    }

    public final Query Clause(String field) throws ParseException {
        Query q;
        Token fieldToken = null;
        Token boost = null;
        if (this.jj_2_1(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    fieldToken = this.jj_consume_token(20);
                    this.jj_consume_token(14);
                    field = this.discardEscapeChar(fieldToken.image);
                    break;
                }
                case 15: {
                    this.jj_consume_token(15);
                    this.jj_consume_token(14);
                    field = "*";
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        block5 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                q = this.Term(field);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                q = this.Query(field);
                this.jj_consume_token(13);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        boost = this.jj_consume_token(26);
                        break block5;
                    }
                }
                this.jj_la1[6] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (boost != null) {
            float f = 1.0f;
            try {
                f = Float.valueOf(boost.image).floatValue();
                q.setBoost(f);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return q;
    }

    public final Query Term(String field) throws ParseException {
        Query q;
        Token boost = null;
        Token fuzzySlop = null;
        boolean prefix = false;
        boolean wildcard = false;
        boolean fuzzy = false;
        boolean rangein = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 20: 
            case 22: 
            case 23: 
            case 26: {
                Token term;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        term = this.jj_consume_token(20);
                        break;
                    }
                    case 15: {
                        term = this.jj_consume_token(15);
                        wildcard = true;
                        break;
                    }
                    case 22: {
                        term = this.jj_consume_token(22);
                        prefix = true;
                        break;
                    }
                    case 23: {
                        term = this.jj_consume_token(23);
                        wildcard = true;
                        break;
                    }
                    case 26: {
                        term = this.jj_consume_token(26);
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        fuzzySlop = this.jj_consume_token(21);
                        fuzzy = true;
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                    }
                }
                block24 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        boost = this.jj_consume_token(26);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                fuzzySlop = this.jj_consume_token(21);
                                fuzzy = true;
                                break block24;
                            }
                        }
                        this.jj_la1[10] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                    }
                }
                String termImage = this.discardEscapeChar(term.image);
                if (wildcard) {
                    q = this.getWildcardQuery(field, termImage);
                    break;
                }
                if (prefix) {
                    q = this.getPrefixQuery(field, this.discardEscapeChar(term.image.substring(0, term.image.length() - 1)));
                    break;
                }
                if (fuzzy) {
                    float fms = this.fuzzyMinSim;
                    try {
                        fms = Float.valueOf(fuzzySlop.image.substring(1)).floatValue();
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    if (fms < 0.0f || fms > 1.0f) {
                        throw new ParseException("Minimum similarity for a FuzzyQuery has to be between 0.0f and 1.0f !");
                    }
                    q = this.getFuzzyQuery(field, termImage, fms);
                    break;
                }
                q = this.getFieldQuery(field, termImage);
                break;
            }
            case 24: {
                Token goop2;
                Token goop1;
                this.jj_consume_token(24);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        goop1 = this.jj_consume_token(30);
                        break;
                    }
                    case 29: {
                        goop1 = this.jj_consume_token(29);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        this.jj_consume_token(27);
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        goop2 = this.jj_consume_token(30);
                        break;
                    }
                    case 29: {
                        goop2 = this.jj_consume_token(29);
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(28);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        boost = this.jj_consume_token(26);
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                    }
                }
                if (goop1.kind == 29) {
                    goop1.image = goop1.image.substring(1, goop1.image.length() - 1);
                }
                if (goop2.kind == 29) {
                    goop2.image = goop2.image.substring(1, goop2.image.length() - 1);
                }
                q = this.getRangeQuery(field, this.discardEscapeChar(goop1.image), this.discardEscapeChar(goop2.image), true);
                break;
            }
            case 25: {
                Token goop2;
                Token goop1;
                this.jj_consume_token(25);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 34: {
                        goop1 = this.jj_consume_token(34);
                        break;
                    }
                    case 33: {
                        goop1 = this.jj_consume_token(33);
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 31: {
                        this.jj_consume_token(31);
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 34: {
                        goop2 = this.jj_consume_token(34);
                        break;
                    }
                    case 33: {
                        goop2 = this.jj_consume_token(33);
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(32);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        boost = this.jj_consume_token(26);
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                    }
                }
                if (goop1.kind == 33) {
                    goop1.image = goop1.image.substring(1, goop1.image.length() - 1);
                }
                if (goop2.kind == 33) {
                    goop2.image = goop2.image.substring(1, goop2.image.length() - 1);
                }
                q = this.getRangeQuery(field, this.discardEscapeChar(goop1.image), this.discardEscapeChar(goop2.image), false);
                break;
            }
            case 17: {
                Token term = this.jj_consume_token(17);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        fuzzySlop = this.jj_consume_token(21);
                        break;
                    }
                    default: {
                        this.jj_la1[20] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        boost = this.jj_consume_token(26);
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                    }
                }
                q = this.getFieldQuery(field, term.image.substring(1, term.image.length() - 1));
                if (fuzzySlop == null || !(q instanceof PhraseQuery)) break;
                try {
                    int s = Float.valueOf(fuzzySlop.image.substring(1)).intValue();
                    ((PhraseQuery)q).setSlop(s);
                }
                catch (Exception ignored) {}
                break;
            }
            case 18: {
                Token term = this.jj_consume_token(18);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        fuzzySlop = this.jj_consume_token(21);
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        boost = this.jj_consume_token(26);
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                    }
                }
                q = this.getUnanalyzedQuery(field, term.image.substring(1, term.image.length() - 1));
                if (fuzzySlop == null || !(q instanceof PhraseQuery)) break;
                try {
                    int s = Float.valueOf(fuzzySlop.image.substring(1)).intValue();
                    ((PhraseQuery)q).setSlop(s);
                }
                catch (Exception ignored) {}
                break;
            }
            case 19: {
                Token term = this.jj_consume_token(19);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        fuzzySlop = this.jj_consume_token(21);
                        break;
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        boost = this.jj_consume_token(26);
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                    }
                }
                Analyzer newAnalyzer = this.analyzer;
                try {
                    if (this.sLocs.getField(field) != null) {
                        newAnalyzer = this.sLocs.getField(field).getAnalyzer();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                q = term.image.indexOf("?") > -1 || term.image.indexOf("*") > -1 ? this.getWildcardQuery(field, newAnalyzer, term.image.substring(1, term.image.length() - 1)) : this.getFieldQuery(field, newAnalyzer, term.image.substring(1, term.image.length() - 1));
                if (fuzzySlop == null || !(q instanceof PhraseQuery)) break;
                try {
                    int s = Float.valueOf(fuzzySlop.image.substring(1)).intValue();
                    ((PhraseQuery)q).setSlop(s);
                }
                catch (Exception ignored) {}
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (boost != null) {
            float f = 1.0f;
            try {
                f = Float.valueOf(boost.image).floatValue();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (q != null) {
                q.setBoost(f);
            }
        }
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            Object var5_4 = null;
            this.jj_save(0, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(0, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(0, xla);
                throw throwable;
            }
        }
    }

    private final boolean jj_3R_3() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_2() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_scan_token(14);
    }

    private final boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_3()) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{384, 384, 3584, 3584, 132030336, 0x108000, 65536, 132026368, 80773120, 0x200000, 0x200000, 65536, 0x60000000, 0x8000000, 0x60000000, 65536, 0, Integer.MIN_VALUE, 0, 65536, 0x200000, 65536, 0x200000, 65536, 0x200000, 65536, 132022272};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public DefaultQueryParser(CharStream stream) {
        int i;
        this.token_source = new DefaultQueryParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public DefaultQueryParser(DefaultQueryParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(DefaultQueryParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[35];
        for (i = 0; i < 35; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 27; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 35; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        DefaultQueryParser.jj_la1_0();
        DefaultQueryParser.jj_la1_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    public static final class Operator
    extends Parameter {
        public static final Operator OR = new Operator("OR");
        public static final Operator AND = new Operator("AND");

        private Operator(String name) {
            super(name);
        }
    }
}

