<?xml version="1.0" encoding="UTF-8"?>
<!--
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx" exclude-result-prefixes="sdx">
    <xsl:import href="skin.xsl"/>
    <xsl:template match="sdx:uploadDocuments">
        <h2>
            <xsl:text>Import de document</xsl:text>
            <xsl:if test="number(sdx:summary/@additions) &gt; 1">s</xsl:if>
        </h2>
        <xsl:apply-templates select="sdx:summary"/>
        <ul>
            <xsl:apply-templates select="sdx:uploadDocument/sdx:addition | sdx:uploadDocument/sdx:attached | sdx:uploadDocument/sdx:sub | sdx:uploadDocument/sdx:original"/>
        </ul>
    </xsl:template>
    <!--matching first order additions-->
    <xsl:template match="sdx:uploadDocument/sdx:addition/sdx:document">
        <li>
            <b>
                <xsl:value-of select="@id"/>
            </b>
            <xsl:text> indexé. </xsl:text>
        </li>
        <xsl:if test="/sdx:document/sdx:parameters/sdx:parameter[@name='url']">
            <iframe width="100%" height="200" src="{/sdx:document/sdx:parameters/sdx:parameter[@name='url']/@value}" title="Un nouveau document cherchable"/>
        </xsl:if>
    </xsl:template>
    <!--matching attached document addition(s)-->
    <xsl:template match="sdx:uploadDocument/sdx:attached/sdx:addition/sdx:document">
        <li>
            <b>
                <xsl:value-of select="@id"/>
            </b>
            <xsl:text> document attaché. </xsl:text>
        </li>
    </xsl:template>
    <!--matching sub document addition(s)-->
    <xsl:template match="sdx:uploadDocument/sdx:sub/sdx:addition/sdx:document">
        <li>
            <b>
                <xsl:value-of select="@id"/>
            </b>
            <xsl:text> sous document. </xsl:text>
        </li>
    </xsl:template>
    <!--matching original document addition-->
    <xsl:template match="sdx:uploadDocument/sdx:original/sdx:addition/sdx:document">
        <li>
            <b>
                <xsl:value-of select="@id"/>
            </b>
            <xsl:text> document original. </xsl:text>
        </li>
    </xsl:template>
    <xsl:template match="sdx:uploadDocument[sdx:exception]">
        <li>
            <b>
                <xsl:value-of select="@id"/>
            </b>
            <xsl:text> erreur. </xsl:text>
            <xsl:apply-templates select="sdx:exception/sdx:message"/>
        </li>
    </xsl:template>
    <xsl:template match="sdx:summary">
        <div>
            <xsl:apply-templates select="@*"/>
        </div>
    </xsl:template>
    <xsl:template match="@additions">
        <xsl:if test="number(.) &gt; 0">
            <xsl:value-of select="."/> document<xsl:if test="number(.) &gt; 1">s</xsl:if>
        ajouté<xsl:if test="number(.) &gt; 1">s</xsl:if>, 
        </xsl:if>
    </xsl:template>
    <xsl:template match="@failures">
        <xsl:if test="number(.) &gt; 0">
            <xsl:value-of select="."/> échec<xsl:if test="number(.) &gt; 1">s</xsl:if>, 
        </xsl:if>
    </xsl:template>
    <xsl:template match="@replacements">
        <xsl:value-of select="."/> document<xsl:if test="number(.) &gt; 1">s</xsl:if> remplacé<xsl:if test="number(.) &gt; 1">s</xsl:if>
    </xsl:template>
    <xsl:template match="@duration"> (<xsl:value-of select="."/> secondes).</xsl:template>
    <xsl:template match="sdx:uploadDocument/sdx:exception">
        <h2>Erreur</h2>
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="sdx:uploadDocument/sdx:exception/sdx:message">
        <small>
            <xsl:apply-templates/>
        </small>
    </xsl:template>
    <xsl:template match="sdx:results">
        <br/>
        <div style="font-family:sans-serif">
            <b>Champs indexés</b>
            <xsl:apply-templates select="sdx:result"/>
        </div>
    </xsl:template>
    <xsl:template match="sdx:result">
        <br/>
        <xsl:apply-templates select="sdx:field">
            <xsl:sort select="@name"/>
            <xsl:sort select="@value"/>
        </xsl:apply-templates>
        <br/>
    </xsl:template>
    <!-- sdx:field -->
    <xsl:template match="sdx:field">
        <div>
            <span class="sdx_field-name" style="font-weight:bold">
                <xsl:value-of select="@name"/>
            </span>
            <xsl:text>:"</xsl:text>
            <span class="sdx_field-value">
                <xsl:value-of select="@value"/>
            </span>
            <xsl:text>"</xsl:text>
        </div>
    </xsl:template>
    <xsl:template match="sdx:field[@name='lien']">
        <div>
            <a href="{normalize-space(.)}">
                <xsl:value-of select="."/>
            </a>
        </div>
    </xsl:template>
    <!-- url d'image -->
    <xsl:template match="sdx:field[@name='image']">
        <img src="{.}"/>
    </xsl:template>
    <xsl:template match="sdx:terms">
        <br/>
        <div>
            <b>Termes indexés</b>
        </div>
        <small>
            <xsl:apply-templates select="sdx:term"/>
        </small>
    </xsl:template>
    <xsl:template match="sdx:term">
        <xsl:value-of select="@value"/>
        <xsl:text>&#32;</xsl:text>
    </xsl:template>
</xsl:stylesheet>
