/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.util.apache.cocoon.xml;

import fr.gouv.culture.util.apache.avalon.excalibur.concurrent.Mutex;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.cocoon.xml.XMLConsumer;

public abstract class AbstractSynchronizedXMLProducer extends Mutex implements SynchronizedXMLProducer, Recyclable {

    /** The <code>XMLConsumer</code> receiving SAX events. */
    protected SynchronizedXMLConsumer synchronizedXmlConsumer;

    /**
     * Set the <code>XMLConsumer</code> that will receive XML data.
     * <br>
     */
    public void setConsumer(SynchronizedXMLConsumer consumer) {
        this.synchronizedXmlConsumer = consumer;
    }

    /**
     * Set the <code>XMLConsumer</code> that will receive XML data.
     * Note we will attempt to synchronize this internally. Do not use
     * this method if peforming synchronization externally on the provided
     * consumer as this will cause deadlock since we synchronize internally.
     * To be safe use @see setConsumer(SynchronizedXMLConsumer consumer).
     * <br>
     */
    public void setConsumer(XMLConsumer consumer) {
        if (consumer != null)
            this.setConsumer(new SynchronizedXMLConsumerWrapper(consumer));
    }

    /**
     * Recycle the producer by removing references
     */
    public void recycle() {
        this.synchronizedXmlConsumer = null;
    }

}
