/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.utils.lucene;

import java.util.Date;

import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.utils.database.Property;

public class LuceneDataField extends Property {


    /** Le type de champ dont il s'agit. */
    protected int fieldType;

    /** Indique s'il doit etre retourne dans la liste des resultats. */
    protected boolean inBrief = true;//defaulted
    protected org.apache.lucene.document.Field.Store store = org.apache.lucene.document.Field.Store.YES;

    /**String representation of the field type. */
    public static final String FIELD_TYPE_WORD = "WORD";

    /**String representation of the field type. */
    public static final String FIELD_TYPE_FIELD = "FIELD";

    /**String representation of the field type. */
    public static final String FIELD_TYPE_DATE = "DATE";

    /**String representation of the field type. */
    public static final String FIELD_TYPE_UNINDEXED = "UNINDEXED";

    /** Field type "word". */
    public static final int WORD = 0;

    /** Field type "field" */
    public static final int FIELD = 1;

    /** Field type "date". */
    public static final int DATE = 2;

    /** Field type "unindexed".*/
    public static final int UNINDEXED = 3;

    /**Sets the type for this field
     *
     * @param type  The field type as a string from our configuration object (element in app.xconf)
     */
    public void setFieldType(String type) {
        if (type.equalsIgnoreCase(FIELD_TYPE_WORD)) {
            fieldType = WORD;
        } else if (type.equalsIgnoreCase(FIELD_TYPE_FIELD)) {
            fieldType = FIELD;
        } else if (type.equalsIgnoreCase(FIELD_TYPE_DATE)) {
            fieldType = DATE;
        } else if (type.equalsIgnoreCase(FIELD_TYPE_UNINDEXED)) {
            fieldType = UNINDEXED;
        } else
            fieldType = WORD;
    }

    // TODO : old Lucene [MP]
    public void setFieldType(boolean store, boolean index, boolean token) {
        setStore(store);
        if (index & !token) {
            fieldType = FIELD;
        } else if (!index & !token) {
            fieldType = UNINDEXED;
        } else if (index & token)
            fieldType = WORD;
    }

    /**
     *	Returns the type Name of the field.
     */
    public String getTypeName() {
        if (this.fieldType == WORD) return FIELD_TYPE_WORD.toLowerCase(/*this.locale*/);
        if (this.fieldType == FIELD) return FIELD_TYPE_FIELD.toLowerCase(/*this.locale*/);
        if (this.fieldType == DATE) return FIELD_TYPE_DATE.toLowerCase(/*this.locale*/);
        if (this.fieldType == UNINDEXED) return FIELD_TYPE_UNINDEXED.toLowerCase(/*this.locale*/);
        return null;
    }

    /**
     *	Returns the Lucene field for the search field.
     *
     * In the case of a field of type "date", if the contents can be interpreted
     * as a date it will be  inserted this way, if not it will be inserted like
     * a field of type "keyword".
     *
     *	@param content The field's content.
     */
    public org.apache.lucene.document.Field getLuceneField(String content) {
        switch (fieldType) {
            case DATE:
                // We will try to get a date
                Date date = fr.gouv.culture.sdx.utils.Date.parseDate(content);
                if (date != null)
                	// MAJ Lucene 2.1.0
                    //return new org.apache.lucene.document.Field(name, DateField.dateToString(date), store, true, false, false);
                	return new org.apache.lucene.document.Field(name, DateField.dateToString(date), store, org.apache.lucene.document.Field.Index.UN_TOKENIZED);
                else
                	// MAJ Lucene 2.1.0
                    //return new org.apache.lucene.document.Field(name, content, inBrief, true, false, false);
                	return new org.apache.lucene.document.Field(name, content, store, org.apache.lucene.document.Field.Index.UN_TOKENIZED);

            case FIELD:
            	// MAJ Lucene 2.1.0
                //return new org.apache.lucene.document.Field(name, content, inBrief, true, false, false);
            	return new org.apache.lucene.document.Field(name, content, store, org.apache.lucene.document.Field.Index.UN_TOKENIZED);
            case WORD:
            	// MAJ Lucene 2.1.0
                //return new org.apache.lucene.document.Field(name, content, inBrief, true, true); //TODO: how to get the storeTermVector value from here ? -la
            	return new org.apache.lucene.document.Field(name, content, store, org.apache.lucene.document.Field.Index.TOKENIZED);
            case UNINDEXED:
            	// MAJ Lucene 2.1.0
                //return new org.apache.lucene.document.Field(name, content, inBrief, false, false, false);
            	return new org.apache.lucene.document.Field(name, content, store, org.apache.lucene.document.Field.Index.NO);
            default:		// Shoud neved happen, but still we return a tokenized field but unstore
            	// MAJ Lucene 2.1.0
                //return new org.apache.lucene.document.Field(name, content, false, true, true, false);
            	return new org.apache.lucene.document.Field(name, content, org.apache.lucene.document.Field.Store.NO, org.apache.lucene.document.Field.Index.TOKENIZED);
        }
    }


    public void setStore(boolean _store) {
        this.inBrief = _store;
    }
}
