/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.SdxObject;

import java.sql.Connection;

public interface DatabaseConnection extends SdxObject {
    String CLASS_NAME_SUFFIX = "DatabaseConnection";

    /**
     * Commit all operation done with this active connection.
     */
    public void commit() throws SDXException;

    /**
     * Undo all operations done with this connection.
     */
    public void rollback() throws SDXException;

    /**
     * Sets this connection in autocommit mode or not.
     *
     * @param   autoCommit      true enables auto-commit ; false disables auto-commit.
     */
    public void setAutoCommit(boolean autoCommit) throws SDXException;

    /**Can do optimization of a Repository if needed*/
    public void optimize() throws SDXException;

    /**
     * Returns the SQL connection
     */
    public Connection getConnection();

    /**Closes the connectiokbn*/
    public void close() throws SDXException;


}
