/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.utils.constants;

import fr.gouv.culture.sdx.framework.Framework;

public interface Node {


    interface Name {

        //Currently used as both element and attribute names in sdx output
        String FIELD = "field";
        String QUERY = "query";
        //Currently used as element names in sdx output
        String DOCUMENT = "document";
        String ATTACHED_DOCUMENT = "attachedDocument";
        String EXCEPTION = "exception";
        String GROUP = "group";
        String MESSAGE = "message";
        String NAVIGATION = "navigation";
        String NEXT = "next";
        String PARAMETER = "parameter";
        String PARAMETERS = "parameters";
        String PREVIOUS = "previous";
        String RESULT = "result";
        String RESULTS = "results";
        String SORT = "sort";
        String TERM = "term";
        String TERMS = "terms";
        String USER = "user";
        String DELETION = "deletion";
        String DELETIONS = "deletions";
        String FILTER = "filter";
        String COMPONENT = "component";
        String BASE_QUERY = "baseQuery";
        String ORIGINAL_EXCEPTION = "originalException";
        String UPLOAD_DOCUMENT = "uploadDocument";
        String UPLOAD_DOCUMENTS = "uploadDocuments";
        String HIGHLIGHT_TERMS = "hilites";
        String ANALYZER_CLASS = "analyzerClass";
        String HILITE = "hilite";
        String SUMMARY = "summary";
        //Current use as attribute names in sdx output
        // results and terms attributes
        String QID = "qid";
        String QUERY_ID = "queryId";
        String APPID = "app";
        String APP = "app";
        String APPBYPATH = "appbypath";
        String BASE = "base";
        String DB_ID = "base";
        String ID = "id";
        String ATTID = "attid"; // id of an attached document, relative to a main document id
        String NO = "no";
        String NB = "nb";
        String PAGE = "page";
        String PAGES = "pages";
        String NB_PAGES = "nbPages";
        String CURRENT_PAGE = "currentPage";
        String DOCS = "docs";
        String DOC_FREQ = "docFreq";
        String BEGIN_DATE = "from";
        String END_DATE = "to";
        String OPERATOR = "operator";
        String OP = "op";
        // deprecated
        String DOC_ID = "docId";
        String DOC_NO = "docNo";
        // Query attributes
        String SIMPLE_QUERY = "simple";
        String TEXT = "text";
        String ESCAPED_TEXT = "escapedText";
        String LUCENE_QUERY = "luceneQuery";
        String ESCAPED_LUCENE_QUERY = "escapedLuceneQuery";
        String SEARCH_ENGINE = "engine";
        String QUERYPARSER_CLASS = "queryParserClass";
        String SEARCH_LOCATIONS = "searchLocations";
        String SEARCH_LOCATION = "searchLocation";
        // others
        String FRAGMENT = "fragment";
        String DATE = "date";
        String ADMIN = "admin";
        String ANONYMOUS = "anonymous";
        String API_URL = "api-url";
        String CLASS = "class";
        String CODE = "code";
        String END = "end";
        String ESCAPED_VALUE = "escapedValue";
        String HPP = "hpp";
        String INDEXED = "indexed";
        String NAME = "name";
        String NEXT_DOCUMENT = "nextDocument";
        String ORDER = "order";
        String PCT_SCORE = "pctScore";
        String PREVIOUS_DOCUMENT = "previousDocument";
        String SCORE = "score";
        String SERVER = "server";
        String START = "start";
        String TOKENIZED = "tokenized";
        String TYPE = "type";
        String URI = "uri";
        String VALUE = "value";
        String LANG = "lang";
        String XML_LANG = Framework.XMLNamespacePrefix + ":" + LANG;
        String VARIANT = "variant";
        String REPO = "repo";
        String STATUS = "status";
        String DOCTYPE = "doctype";
        String ADDITIONS = "additions";
        String ADDITION = "addition";
        String FAILURES = "failures";
        String DURATION = "duration";
        String URL = "url";
        String MIMETYPE = "mimetype";
        String BYTE_LENGTH = "byte-length";
        String GENERATE_ID = "generateId";
        String OVERRIDE_ID = "overrideId";
        // User
        String IP = "ip";
        String HOST = "host";
        String SUPERUSER = "superuser";
        String EMAIL = "email";
        String FIRSTNAME = "firstname";
        String LASTNAME = "lastname";
        //For our thesaurus classes
        String CONCEPT = "concept";
        String RELATIONS = "relations";
        String RELATION = "relation";
        String REF = "ref";
        String THESAURUS = "thesaurus";
        String P = "p";
        String DEPTH = "depth";
        String EXPAND_FIELD = "expandField";
        String TH = "th";
        // misc
        String PREVIOUS_HARVEST = "previousHarvest";
        String PREVIOUS_HARVESTS = "previousHarvests";
        String STORED_HARVEST_REQUESTS = "storedHarvestRequests";
        String BOOST = "boost";
        String OWNERS = "owners";
        String LOCALE = "locale";
        String ENCODING = "encoding";
        String OBJECT = "object";
        String XMLNS = "xmlns";
    }

    interface Value {

        String TRUE = "true";
        String ASCENDING = "ascending";
        String DESCENDING = "descending";
        String FAILURE = "failure";
    }

    interface Type {
        String CDATA = "CDATA";
    }

    interface Prefix {
        String SDX = "sdx";
        String XSI = "xsi";
    }

    interface Uri {
        String SDX = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String XML = "http://www.w3.org/XML/1998/namespace";
    }

}
