/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/

package fr.gouv.culture.sdx.utils.constants;


public interface ContextKeys {

    interface SDX {

        /** String representation for a key in the ContextKeys object : security policy. */
        String JAVA_SECURITY_POLICY = "java.securityPolicy";
        /** String representation for a key in the ContextKeys object :  the encoding string provided by the parent ContextKeys object. */
        String ENCODING = "sdx.encoding";


        interface Framework {
            /** String representation for a key in the ContextKeys object : framework's configuration file. */
            String CONFIGURATION_FILE = "sdx.framework.confFile";
            /** String representation for a key in the ContextKeys object : framework's context directory. */
            String ROOT_PATH = "sdx.framework.rootPath";
            /** String representation for a key in the ContextKeys object : framework's configuration directory. */
            String CONFIGURATION_PATH = "sdx.framework.confPath";
            /** String representation for a key in the ContextKeys object :  framework's libraries. */
            String LIBRARY_PATH = "sdx.framework.libPath";
            /** String representation for a key in the ContextKeys object : famework's RMI host. */
            String RMI_HOST = "sdx.framework.rmiHost";
            /** String representation for a key in the ContextKeys object : famework's RMI port. */
            String RMI_PORT = "sdx.framework.rmiPort";
            /** String representation for a key in the ContextKeys object :  framework's analyzer manager. */
            String ANALYZER_MGR = "sdx.framework.analyzerMgr";
        }

        interface Application {
            /** String representation for a key in the ContextKeys object : framework's applications names. */
            String DIRECTORY_NAME = "sdx.application.dirName";
            /** String representation for a key in the ContextKeys object : framework's applications configuration directories. */
            String CONFIGURATION_DIRECTORY_PATH = "sdx.application.confDirPath";
            /** String representation for a key in the ContextKeys object :  framework's applications configurations. */
            String CONFIGURATION_OBJECT = "sdx.application.confObj";
            /** String representation for a key in the ContextKeys object : application's id. */
            String ID = "sdx.application.id";
            /** String representation for a key in the ContextKeys object : application's name. */
            String NAME = "sdx.application.name";
            /** String representation for a key in the ContextKeys object : application-level repositories. */
            String REPOSITORIES = "sdx.application.repos";
            /** String representation for a key in the ContextKeys object : application-level repositories. */
            String FIELD_LISTS = "sdx.application.fieldLists";
            /** String representation for a key in the ContextKeys object : directory for the location of the backup files. */
            String BACKUP_DIRECTORY_PATH = "sdx.application.backupDirPath";
            /** String representation for a key in the ContextKeys object : directory for the location of the DBs. */
            String DATADIR_DIRECTORY_PATH = "sdx.application.dataDirPath";
            /** String representation for a key in the ContextKeys object : is datadir shared */
            String IS_DATADIR_SHARED = "sdx.application.dataDir.shared";
            /** String representation for a key in the ContextKeys object : indexation logging level*/
            String INDEXATION_LOGGING_LEVEL = "sdx.application.indexation.logging.level";
            /** String representation for a key in the ContextKeys object : directory for the location of the DBs. */
            String DOCUMENTBASES_DIRECTORY_PATH = "sdx.application.dbsDirPath";
            /** String representation for a key in the ContextKeys object : directory for the location of the repositories. */
            String REPOSITORIES_DIRECTORY_PATH = "sdx.application.reposDirPath";
            /** String representation for a key in the ContextKeys object : directory for the location of the users info. */
            String USERS_DIRECTORY_PATH = "sdx.application.usersDirPath";
            /** String representation for a key in the ContextKeys object : directory for the location of the users' documents. */
            String USERS_DOCUMENTBASE_DIRECTORY_PATH = "sdx.application.userDocBaseDirPath";
            /** String representation for a key in the ContextKeys object : directory for the location of the thesauri. */
            String THESAURI_DIRECTORY_PATH = "sdx.application.thesauriDirPath";
            /** The key name for the database directory of this application in the "_context" object. */
            String DATABASE_DIRECTORY_PATH = "sdx.application.databaseDirPath";
            /** The key name for the potention hsql db of this application in the "_context" object. */
            String HSQL_DATABASE_OBJECT = "sdx.application.hsqldb";
            /** The key name for the default database type this application in the "_context" object. */
            String DEFAULT_DATABASE_CONFIGURATION_OBJECT = "sdx.application.defaultDatabaseConfObj";
        }

        interface DocumentBase {

            /** String representation for a key in the ContextKeys object : fields definition object. */
            String FIELD_LIST = "sdx.documentbase.fieldList";
            /** String representation for a key in the ContextKeys object : document base's directory location. */
            String DIRECTORY_PATH = "sdx.documentbase.dbDirPath";
        }

    }

}
