/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.user;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.framework.Framework;
import fr.gouv.culture.sdx.utils.constants.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import java.util.Hashtable;
import java.util.Locale;

/**
 * An anonymous SDX user.
 *
 * <p>
 * The information for this user will be sent directly and not from an
 * XML document.
 */
public class AnonymousUserInformation extends UserInformation {

    /**
     * Creates an anonymous user with a preferred locale.
     *
     * @param   locale      The preferred locale.
     */
    public AnonymousUserInformation(Locale locale) throws SDXException {
        setId(UserInformation.ANONYMOUS_USERNAME);
        setGroups(new Hashtable());
        setPreferredLocale(locale);
    }

    /**
     * Sends information about this anonymous user.
     *
     * <p>
     * The information sent is basically a user definition with an
     * anonymous property set to true.
     *
     * @param   handler     The handler where to send events.
     */
    public void toSAX(ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", Node.Name.ANONYMOUS, Node.Name.ANONYMOUS, Node.Type.CDATA, "true");
        if (super.ip != null) atts.addAttribute("", Node.Name.IP, Node.Name.IP, Node.Type.CDATA, super.ip);
        if (super.host != null) atts.addAttribute("", Node.Name.HOST, Node.Name.HOST, Node.Type.CDATA, super.host);
        handler.startElement(Framework.SDXNamespaceURI, Node.Name.USER, Framework.SDXNamespacePrefix + ":" + Node.Name.USER, atts);
        handler.endElement(Framework.SDXNamespaceURI, Node.Name.USER, Framework.SDXNamespacePrefix + ":" + Node.Name.USER);
    }


}
