/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 17 oct. 2002
 * Time: 16:02:28
 * To change template for new class use
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;

public abstract class AbstractRepositoryConnection extends AbstractSdxObject implements RepositoryConnection {

    /**Can do optimization of a Repository if needed*/
    public void optimize() throws SDXException {
    }

    /**
     * Sets this connection in autocommit mode or not.
     *
     * @param   autoCommit      true enables auto-commit ; false disables auto-commit.
     */
    public void setAutoCommit(boolean autoCommit) throws SDXException {
    }

    /**
     * Undo all operations done with this connection.
     */
    public void rollback() throws SDXException {
    }

    /**
     * Commit all operation done with this active connection.
     */
    public void commit() throws SDXException {
    }

    protected String getClassNameSuffix() {
        return Repository.CLASS_NAME_SUFFIX;
    }

    /* (non-Javadoc)
	 * @see fr.gouv.culture.sdx.utils.AbstractSdxObject#initToSax()
	 */
	protected boolean initToSax() {
		return true;
	}
    
	/**Init the LinkedHashMap _xmlizable_volatile_objects with the objects in order to describ them in XML
	 * Some objects need to be refresh each time a toSAX is called*/
	protected void initVolatileObjectsToSax() {
	
	}
}
