/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.oai;

import fr.gouv.culture.oai.util.OAIUtilities;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Apr 24, 2003
 * Time: 3:37:40 PM
 * To change this template use Options | File Templates.
 */

/**A base class for common variables/behaviors
 *
 */
public abstract class OAIObjectImpl extends AbstractXMLPipe implements OAIObject {

    /**The super.getLog()*/
    protected Logger logger = null;

    protected DefaultContext _context = null;

    /**Establishes the super.getLog()
     *
     * @param logger
     */
    public void enableLogging(Logger logger) {
        this.logger = logger.getChildLogger("oai");
    }

    public void contextualize(Context context) throws ContextException {
        _context = new DefaultContext(context);
    }

    protected DefaultContext getContext() {
        return _context;
    }

    /**Sends a element with the simple character content
     * provided by the <code>elemContent</code> param
     *
     * @param uri   The namespace uri
     * @param localName The local name
     * @param qName The qualified name
     * @param atts The attributes
     * @param elemContent The character content
     * @throws SAXException
     */
    protected void sendElement(String uri, String localName, String qName, Attributes atts, String elemContent) throws SAXException {
        this.startElement(uri, localName, qName, atts);
        this.sendElementContent(elemContent);
        super.endElement(uri, localName, qName);
    }


    /**Sends a start element event*/
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (atts == null) atts = new AttributesImpl();
        super.startElement(uri, localName, qName, atts);

    }
    
    /**Sends a end element event*/
    public void endElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        super.endElement(uri, localName, qName);

    }

    /**Sends character content from the provided string
     *
     * @param content The string of characters to send
     */
    protected void sendElementContent(String content) throws SAXException {
        if (OAIUtilities.checkString(content)) {
            char[] chars = content.toCharArray();
            super.characters(chars, 0, chars.length);
        }

    }


}
