/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.cron;

import java.io.InputStreamReader;
import java.util.Date;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.cron.ConfigurableCronJob;
import org.apache.cocoon.components.cron.ServiceableCronJob;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class TestCronJob
extends ServiceableCronJob
implements Configurable,
ConfigurableCronJob {
    public static final String PARAMETER_MESSAGE = "TestCronJob.Parameter.Message";
    public static final String PARAMETER_SLEEP = "TestCronJob.Parameter.Sleep";
    public static final String PARAMETER_PIPELINE = "TestCronJob.Parameter.Pipeline";
    private String msg;
    private int sleep;
    private String pipeline;

    public void configure(Configuration config) throws ConfigurationException {
        this.msg = config.getChild("msg").getValue("I was not configured");
        this.sleep = config.getChild("sleep").getValueAsInteger(11000);
        this.pipeline = config.getChild("pipeline").getValue("samples/hello-world/hello.xhtml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(String name) {
        block15: {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("CronJob " + name + " launched at " + new Date() + " with message '" + this.msg + "' and sleep timeout of " + this.sleep + "ms");
            }
            SourceResolver resolver = null;
            Source src = null;
            try {
                try {
                    resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                    src = resolver.resolveURI("cocoon://" + this.pipeline);
                    InputStreamReader r = new InputStreamReader(src.getInputStream());
                    try {
                        int n;
                        boolean append = this.getLogger().isInfoEnabled();
                        StringBuffer sb = new StringBuffer();
                        char[] b = new char[8192];
                        while ((n = r.read(b)) > 0) {
                            if (!append) continue;
                            sb.append(b, 0, n);
                        }
                        if (append) {
                            this.getLogger().info("CronJob " + name + " called pipeline " + this.pipeline + " and received following content:\n" + sb.toString());
                        }
                    }
                    finally {
                        r.close();
                    }
                    Object var11_12 = null;
                    if (resolver == null) break block15;
                }
                catch (Exception e) {
                    throw new CascadingRuntimeException("CronJob " + name + " raised an exception.", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (resolver != null) {
                    resolver.release(src);
                    this.manager.release((Object)resolver);
                    resolver = null;
                    src = null;
                }
                throw throwable;
            }
            resolver.release(src);
            this.manager.release((Object)resolver);
            resolver = null;
            src = null;
        }
        try {
            Thread.sleep(this.sleep);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("CronJob " + name + " finished at " + new Date() + " with message '" + this.msg + "' and sleep timeout of " + this.sleep + "ms");
        }
    }

    public void setup(Parameters params, Map objects) {
        if (null != params) {
            this.msg = params.getParameter(PARAMETER_MESSAGE, this.msg);
            this.sleep = params.getParameterAsInteger(PARAMETER_SLEEP, this.sleep);
            this.pipeline = params.getParameter(PARAMETER_PIPELINE, this.pipeline);
        }
    }
}

