/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hsqldb.Result;
import org.hsqldb.Types;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.jdbcColumnMetaData;
import org.hsqldb.jdbc.jdbcResultSet;
import org.hsqldb.persist.HsqlProperties;

public class jdbcResultSetMetaData
implements ResultSetMetaData {
    private jdbcColumnMetaData[] columnMetaData;
    private int columnCount;
    private boolean useColumnName;
    private static final boolean TRACE = false;

    jdbcResultSetMetaData(jdbcResultSet jdbcResultSet2, HsqlProperties hsqlProperties) throws SQLException {
        this.init(jdbcResultSet2, hsqlProperties);
    }

    jdbcResultSetMetaData(Result result, HsqlProperties hsqlProperties) throws SQLException {
        this.init(result, hsqlProperties);
    }

    void init(jdbcResultSet jdbcResultSet2, HsqlProperties hsqlProperties) throws SQLException {
        if (jdbcResultSet2 == null) {
            throw Util.sqlException(40, 119, null);
        }
        this.init(jdbcResultSet2.rResult, hsqlProperties);
    }

    void init(Result result, HsqlProperties hsqlProperties) throws SQLException {
        if (result == null) {
            throw Util.sqlException(40, 120, null);
        }
        if (!result.isData()) {
            return;
        }
        this.columnCount = result.getColumnCount();
        this.useColumnName = true;
        if (hsqlProperties != null) {
            this.useColumnName = hsqlProperties.isPropertyTrue("get_column_name", true);
        }
        this.columnMetaData = new jdbcColumnMetaData[this.columnCount];
        Result.ResultMetaData resultMetaData = result.metaData;
        for (int i = 0; i < this.columnCount; ++i) {
            Boolean bl;
            jdbcColumnMetaData jdbcColumnMetaData2;
            this.columnMetaData[i] = jdbcColumnMetaData2 = new jdbcColumnMetaData();
            jdbcColumnMetaData2.catalogName = resultMetaData.catalogNames[i] == null ? "" : resultMetaData.catalogNames[i];
            jdbcColumnMetaData2.schemaName = resultMetaData.schemaNames[i] == null ? "" : resultMetaData.schemaNames[i];
            jdbcColumnMetaData2.tableName = resultMetaData.tableNames[i] == null ? "" : resultMetaData.tableNames[i];
            jdbcColumnMetaData2.columnName = resultMetaData.colNames[i] == null ? "" : resultMetaData.colNames[i];
            jdbcColumnMetaData2.columnLabel = resultMetaData.colLabels[i] == null ? "" : resultMetaData.colLabels[i];
            jdbcColumnMetaData2.columnType = resultMetaData.colTypes[i];
            jdbcColumnMetaData2.columnTypeName = Types.getTypeString(jdbcColumnMetaData2.columnType);
            jdbcColumnMetaData2.isWritable = resultMetaData.isWritable[i];
            jdbcColumnMetaData2.isReadOnly = !jdbcColumnMetaData2.isWritable;
            jdbcColumnMetaData2.isAutoIncrement = resultMetaData.isIdentity[i];
            jdbcColumnMetaData2.isNullable = resultMetaData.colNullable[i];
            int n = jdbcColumnMetaData2.columnType;
            jdbcColumnMetaData2.columnClassName = resultMetaData.classNames[i];
            if (jdbcColumnMetaData2.columnClassName == null || jdbcColumnMetaData2.columnClassName.length() == 0) {
                jdbcColumnMetaData2.columnClassName = Types.getColStClsName(n);
            }
            if (Types.acceptsPrecisionCreateParam(n)) {
                if (resultMetaData.colSizes[i] == 0) {
                    jdbcColumnMetaData2.columnDisplaySize = Types.getMaxDisplaySize(n);
                } else {
                    jdbcColumnMetaData2.columnDisplaySize = resultMetaData.colSizes[i];
                    if (Types.acceptsScaleCreateParam(n) && resultMetaData.colScales[i] != 0) {
                        jdbcColumnMetaData2.columnDisplaySize += 1 + resultMetaData.colScales[i];
                    }
                }
            } else {
                jdbcColumnMetaData2.columnDisplaySize = Types.getMaxDisplaySize(n);
            }
            if (Types.isNumberType(n) && Types.acceptsPrecisionCreateParam(n)) {
                jdbcColumnMetaData2.precision = resultMetaData.colSizes[i];
                if (jdbcColumnMetaData2.precision == 0) {
                    jdbcColumnMetaData2.precision = Types.getPrecision(n);
                }
            } else {
                jdbcColumnMetaData2.precision = Types.getPrecision(n);
            }
            if (Types.acceptsScaleCreateParam(n)) {
                jdbcColumnMetaData2.scale = resultMetaData.colScales[i];
            }
            jdbcColumnMetaData2.isSigned = (bl = Types.isUnsignedAttribute(n)) != null && bl == false;
            Boolean bl2 = Types.isCaseSensitive(n);
            jdbcColumnMetaData2.isCaseSensitive = bl2 != null && bl2 != false;
            jdbcColumnMetaData2.isSearchable = Types.isSearchable(n);
        }
    }

    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isAutoIncrement;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isCaseSensitive;
    }

    public boolean isSearchable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isSearchable;
    }

    public boolean isCurrency(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isCurrency;
    }

    public int isNullable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isNullable;
    }

    public boolean isSigned(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isSigned;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].columnDisplaySize;
    }

    public String getColumnLabel(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].columnLabel;
    }

    public String getColumnName(int n) throws SQLException {
        this.checkColumn(n);
        return this.useColumnName ? this.columnMetaData[n].columnName : this.columnMetaData[--n].columnLabel;
    }

    public String getSchemaName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].schemaName;
    }

    public int getPrecision(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].precision;
    }

    public int getScale(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].scale;
    }

    public String getTableName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].tableName;
    }

    public String getCatalogName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].catalogName;
    }

    public int getColumnType(int n) throws SQLException {
        this.checkColumn(n);
        int n2 = this.columnMetaData[--n].columnType;
        return n2 == 100 ? 12 : n2;
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].columnTypeName;
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isReadOnly;
    }

    public boolean isWritable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isWritable;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isDefinitelyWritable;
    }

    public String getColumnClassName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].columnClassName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        if (this.columnCount == 0) {
            stringBuffer.append("[columnCount=0]");
            return stringBuffer.toString();
        }
        stringBuffer.append('[');
        for (int i = 0; i < this.columnCount; ++i) {
            stringBuffer.append('\n');
            stringBuffer.append("   column_");
            stringBuffer.append(i + 1);
            stringBuffer.append('=');
            stringBuffer.append(this.columnMetaData[i]);
            if (i + 1 >= this.columnCount) continue;
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        stringBuffer.append('\n');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private void checkColumn(int n) throws SQLException {
        if (n < 1 || n > this.columnCount) {
            throw Util.sqlException(28, String.valueOf(n));
        }
    }
}

