/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.layout.renderer.aspect.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.acting.helpers.LayoutEventDescription;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.layout.Layout;
import org.apache.cocoon.portal.layout.impl.CopletLayout;
import org.apache.cocoon.portal.layout.renderer.aspect.RendererAspectContext;
import org.apache.cocoon.portal.layout.renderer.aspect.impl.AbstractAspect;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class HistoryAspect
extends AbstractAspect {
    protected void addValues(String id, List state, Map values, String prefix) {
        Iterator iter = values.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String path = prefix + entry.getKey();
            LayoutEventDescription led = new LayoutEventDescription();
            led.path = path;
            led.layoutId = id;
            led.data = entry.getValue();
            state.add(led);
        }
    }

    public void toSAX(RendererAspectContext context, Layout layout, PortalService service, ContentHandler handler) throws SAXException {
        Request request;
        Session session;
        if (layout.getId() != null && (session = (request = ObjectModelHelper.getRequest((Map)context.getObjectModel())).getSession(false)) != null) {
            ArrayList state;
            ArrayList history = (ArrayList)session.getAttribute("portal-history");
            if (history == null) {
                history = new ArrayList();
            }
            if ((state = (ArrayList)request.getAttribute("portal-history")) == null) {
                state = new ArrayList();
                request.setAttribute("portal-history", state);
                history.add(state);
            }
            this.addValues(layout.getId(), state, layout.getAspectDatas(), "aspectDatas/");
            this.addValues(layout.getId(), state, layout.getParameters(), "parameters/");
            if (layout instanceof CopletLayout) {
                CopletInstanceData cid = ((CopletLayout)layout).getCopletInstanceData();
                this.addValues(cid.getId(), state, cid.getAspectDatas(), "aspectDatas/");
                this.addValues(cid.getId(), state, cid.getAttributes(), "attributes/");
            }
            session.setAttribute("portal-history", history);
        }
        context.invokeNext(layout, service, handler);
    }
}

