/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.core.JavaElement;

class JavaElementInfo {
    protected IJavaElement[] children = JavaElement.NO_ELEMENTS;
    protected boolean isStructureKnown = false;
    static Object[] NO_NON_JAVA_RESOURCES = new Object[0];

    protected JavaElementInfo() {
    }

    public void addChild(IJavaElement child) {
        if (this.children == JavaElement.NO_ELEMENTS) {
            this.setChildren(new IJavaElement[]{child});
        } else if (!this.includesChild(child)) {
            this.setChildren(this.growAndAddToArray(this.children, child));
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    public IJavaElement[] getChildren() {
        return this.children;
    }

    protected IJavaElement[] growAndAddToArray(IJavaElement[] array, IJavaElement addition) {
        IJavaElement[] old = array;
        array = new IJavaElement[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected boolean includesChild(IJavaElement child) {
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i].equals(child)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isStructureKnown() {
        return this.isStructureKnown;
    }

    protected IJavaElement[] removeAndShrinkArray(IJavaElement[] array, IJavaElement deletion) {
        IJavaElement[] old = array;
        array = new IJavaElement[old.length - 1];
        int j = 0;
        int i = 0;
        while (i < old.length) {
            if (old[i].equals(deletion)) {
                System.arraycopy(old, i + 1, array, j, old.length - (i + 1));
                return array;
            }
            array[j] = old[i];
            ++j;
            ++i;
        }
        return array;
    }

    public void removeChild(IJavaElement child) {
        if (this.includesChild(child)) {
            this.setChildren(this.removeAndShrinkArray(this.children, child));
        }
    }

    public void setChildren(IJavaElement[] children) {
        this.children = children;
    }

    public void setIsStructureKnown(boolean newIsStructureKnown) {
        this.isStructureKnown = newIsStructureKnown;
    }
}

