/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentSampleException;
import org.apache.excalibur.instrument.manager.http.AbstractXMLHandler;
import org.apache.excalibur.instrument.manager.http.InstrumentManagerHTTPConnector;

public class XMLSampleLeaseHandler
extends AbstractXMLHandler {
    private InstrumentManagerHTTPConnector m_connector;

    public XMLSampleLeaseHandler(DefaultInstrumentManager manager, InstrumentManagerHTTPConnector connector) {
        super("/sample-lease.xml", manager);
        this.m_connector = connector;
    }

    public void doGet(String path, Map parameters, PrintWriter out) throws IOException {
        InstrumentSampleDescriptor desc;
        String name = this.getParameter(parameters, "name");
        long lease = this.getLongParameter(parameters, "lease");
        boolean packed = this.getBooleanParameter(parameters, "packed", false);
        try {
            desc = this.getInstrumentManager().locateInstrumentSampleDescriptor(name);
        }
        catch (NoSuchInstrumentSampleException e) {
            throw new FileNotFoundException("The specified instrument does not exist: " + name);
        }
        lease = Math.max(1L, Math.min(lease, this.m_connector.getMaxLeasedSampleLease()));
        if (this.getInstrumentManager().getLeaseSampleCount() >= this.m_connector.getMaxLeasedSamples()) {
            lease = 1L;
        }
        desc.extendLease(lease);
        out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.outputSample(out, desc, "", packed);
    }
}

