/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentableDescriptor;
import org.apache.excalibur.instrument.manager.http.AbstractHandler;
import org.apache.excalibur.instrument.manager.http.server.URLCoder;

public abstract class AbstractHTMLHandler
extends AbstractHandler {
    public AbstractHTMLHandler(String path, DefaultInstrumentManager manager) {
        super(path, "text/html", manager);
    }

    protected String urlEncode(String str) {
        try {
            return URLCoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unknown encoding: " + e.toString());
        }
    }

    protected void breadCrumbs(PrintWriter out, boolean link) {
        if (link) {
            out.println("<a href='instrument-manager.html'>" + this.getInstrumentManager().getDescription() + "</a>");
        } else {
            out.println(this.getInstrumentManager().getDescription());
        }
    }

    protected void breadCrumbs(PrintWriter out, InstrumentableDescriptor desc, boolean link) {
        InstrumentableDescriptor parent = desc.getParentInstrumentableDescriptor();
        if (parent == null) {
            this.breadCrumbs(out, true);
        } else {
            this.breadCrumbs(out, parent, true);
        }
        out.print(" <b>&gt;</b> ");
        if (link) {
            out.println("<a href='instrumentable.html?name=" + this.urlEncode(desc.getName()) + "'>" + desc.getDescription() + "</a>");
        } else {
            out.println(desc.getDescription());
        }
    }

    protected void breadCrumbs(PrintWriter out, InstrumentDescriptor desc, boolean link) {
        this.breadCrumbs(out, desc.getInstrumentableDescriptor(), true);
        out.print(" <b>&gt;</b> ");
        if (link) {
            out.println("<a href='instrument.html?name=" + this.urlEncode(desc.getName()) + "'>" + desc.getDescription() + "</a>");
        } else {
            out.println(desc.getDescription());
        }
    }

    protected void breadCrumbs(PrintWriter out, InstrumentSampleDescriptor desc, boolean link) {
        this.breadCrumbs(out, desc.getInstrumentDescriptor(), true);
        out.print(" <b>&gt;</b> ");
        if (link) {
            out.println("<a href='sample.html?name=" + this.urlEncode(desc.getName()) + "'>" + desc.getDescription() + "</a>");
        } else {
            out.println(desc.getDescription());
        }
    }

    protected void startTable(PrintWriter out) throws IOException {
        out.println("<table cellpadding='1' cellspacing='0'><tr><td bgcolor='#bbbbbb'><table cellpadding='2' cellspacing='1'>");
    }

    protected void endTable(PrintWriter out) throws IOException {
        out.println("</table></td></tr></table>");
    }

    protected void startTableHeaderRow(PrintWriter out) throws IOException {
        out.println("<tr>");
    }

    protected void endTableHeaderRow(PrintWriter out) throws IOException {
        out.println("</tr>");
    }

    protected void tableHeaderCell(PrintWriter out, String value) throws IOException {
        out.print("<td bgcolor='#dddddd' nowrap><b>" + value + "</b></td>");
    }

    protected void startTableRow(PrintWriter out, int row) throws IOException {
        String color = row % 2 == 0 ? "#eeeeee" : "#e4e4e4";
        out.println("<tr bgcolor='" + color + "'>");
    }

    protected void endTableRow(PrintWriter out) throws IOException {
        out.println("</tr>");
    }

    protected void tableCell(PrintWriter out, String value) throws IOException {
        out.print("<td nowrap>" + value + "</td>");
    }

    protected void tableCellRight(PrintWriter out, String value) throws IOException {
        out.print("<td align='right' nowrap>" + value + "</td>");
    }

    protected void tableRow(PrintWriter out, int row, String label, String value) throws IOException {
        this.startTableRow(out, row);
        this.tableHeaderCell(out, label);
        this.tableCell(out, value);
        this.endTableRow(out);
    }

    protected void footer(PrintWriter out) {
        out.println("<br>");
        out.print("<font size='-1' color='#888888'>");
        out.print("<center>");
        out.print("<a href='http://excalibur.apache.org/instrument/html-client.html'>");
        out.print("Excalibur Instrument - HTTP Client");
        out.print("</a><br>");
        out.print("Copyright&copy; 2002-2004 The Apache Software Foundation.  All rights reserved.");
        out.print("</center>");
        out.println("</font>");
    }

    protected void outputInstrumentables(PrintWriter out, InstrumentableDescriptor[] descs) throws IOException {
        this.startTable(out);
        this.startTableHeaderRow(out);
        this.tableHeaderCell(out, "Name");
        this.endTableHeaderRow(out);
        for (int i = 0; i < descs.length; ++i) {
            InstrumentableDescriptor desc = descs[i];
            this.startTableRow(out, i);
            this.tableCell(out, "<a href='instrumentable.html?name=" + this.urlEncode(desc.getName()) + "'>" + desc.getDescription() + "</a>");
            this.endTableRow(out);
        }
        this.endTable(out);
    }

    protected void outputInstruments(PrintWriter out, InstrumentDescriptor[] descs) throws IOException {
        this.startTable(out);
        this.startTableHeaderRow(out);
        this.tableHeaderCell(out, "Name");
        this.endTableHeaderRow(out);
        for (int i = 0; i < descs.length; ++i) {
            InstrumentDescriptor desc = descs[i];
            this.startTableRow(out, i);
            this.tableCell(out, "<a href='instrument.html?name=" + this.urlEncode(desc.getName()) + "'>" + desc.getDescription() + "</a>");
            this.endTableRow(out);
        }
        this.endTable(out);
    }

    protected void outputInstrumentSamples(PrintWriter out, InstrumentSampleDescriptor[] descs, boolean readOnly) throws IOException {
        this.startTable(out);
        this.startTableHeaderRow(out);
        this.tableHeaderCell(out, "Name");
        this.tableHeaderCell(out, "Last Sample");
        this.tableHeaderCell(out, "Last Sample Period");
        this.tableHeaderCell(out, "Interval");
        this.tableHeaderCell(out, "Size");
        this.tableHeaderCell(out, "Expiration Time");
        this.endTableHeaderRow(out);
        for (int i = 0; i < descs.length; ++i) {
            String value;
            InstrumentSampleDescriptor desc = descs[i];
            this.startTableRow(out, i);
            this.tableCell(out, "<a href='sample.html?name=" + this.urlEncode(desc.getName()) + "'>" + desc.getDescription() + "</a> (<a href='sample.html?name=" + this.urlEncode(desc.getName()) + "&chart=true'>Chart</a>)");
            this.tableCellRight(out, Integer.toString(desc.getValue()));
            this.tableCell(out, new Date(desc.getTime()).toString());
            this.tableCellRight(out, Long.toString(desc.getInterval()));
            this.tableCellRight(out, Integer.toString(desc.getSize()));
            if (desc.getLeaseExpirationTime() == 0L) {
                value = "<i>Permanent</i>";
            } else {
                String renewUrl = "sample-lease.html?name=" + this.urlEncode(desc.getName()) + "&instrument=true&lease=";
                value = new Date(desc.getLeaseExpirationTime()).toString();
                if (!readOnly) {
                    value = value + " (Renew <a href='" + renewUrl + "600000'>10min</a>, " + "<a href='" + renewUrl + "3600000'>1hr</a>, " + "<a href='" + renewUrl + "86400000'>1day</a>)";
                }
                if (desc.getLeaseExpirationTime() - System.currentTimeMillis() < 300000L) {
                    value = "<font color='ff0000'>" + value + "</font>";
                }
            }
            this.tableCell(out, value);
            this.endTableRow(out);
        }
        this.endTable(out);
    }
}

