/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

final class TRStringDistance {
    final char[] sa;
    final int n;
    final int[][][] cache = new int[30][][];

    public TRStringDistance(String target) {
        this.sa = target.toCharArray();
        this.n = this.sa.length;
    }

    public final int getDistance(String other) {
        int[][] d;
        char[] ta = other.toCharArray();
        int m = ta.length;
        if (this.n == 0) {
            return m;
        }
        if (m == 0) {
            return this.n;
        }
        if (m >= this.cache.length) {
            d = TRStringDistance.form(this.n, m);
        } else if (this.cache[m] != null) {
            d = this.cache[m];
        } else {
            this.cache[m] = TRStringDistance.form(this.n, m);
            d = this.cache[m];
        }
        for (int i = 1; i <= this.n; ++i) {
            char s_i = this.sa[i - 1];
            for (int j = 1; j <= m; ++j) {
                char t_j = ta[j - 1];
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = TRStringDistance.min3(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[this.n][m];
    }

    private static int[][] form(int n, int m) {
        int[][] d = new int[n + 1][m + 1];
        for (int i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (int j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        return d;
    }

    private static int min3(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }
}

