/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class PlsqlIndexTableAccessor
extends Accessor {
    int elementInternalType;
    int maxNumberOfElements;
    int elementMaxLen;
    int ibtValueIndex;
    int ibtIndicatorIndex;
    int ibtLengthIndex;
    int ibtMetaIndex;
    int ibtByteLength;
    int ibtCharLength;

    PlsqlIndexTableAccessor(OracleStatement oracleStatement, int n, int n2, int n3, int n4, short s, boolean bl) throws SQLException {
        this.init(oracleStatement, 998, 998, s, bl);
        this.elementInternalType = n2;
        this.maxNumberOfElements = n4;
        this.elementMaxLen = n3;
        this.initForDataAccess(n, n3, null);
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.externalType = n;
        }
        switch (this.elementInternalType) {
            case 1: 
            case 96: {
                this.internalTypeMaxLength = 2000;
                this.elementMaxLen = (n2 == 0 ? this.internalTypeMaxLength : n2) + 1;
                this.ibtCharLength = this.elementMaxLen * this.maxNumberOfElements;
                this.elementInternalType = 9;
                break;
            }
            case 6: {
                this.internalTypeMaxLength = 21;
                this.elementMaxLen = this.internalTypeMaxLength + 1;
                this.ibtByteLength = this.elementMaxLen * this.maxNumberOfElements;
                break;
            }
            default: {
                DatabaseError.throwSqlException(97);
            }
        }
    }

    Object[] getPlsqlIndexTable(int n) throws SQLException {
        Object[] objectArray = null;
        short[] sArray = this.statement.ibtBindIndicators;
        int n2 = (sArray[this.ibtMetaIndex + 4] >> 16) + (sArray[this.ibtMetaIndex + 5] & 0xFFFF);
        int n3 = this.ibtValueIndex;
        switch (this.elementInternalType) {
            case 9: {
                objectArray = new String[n2];
                char[] cArray = this.statement.ibtBindChars;
                for (int i = 0; i < n2; ++i) {
                    objectArray[i] = sArray[this.ibtIndicatorIndex + i] == -1 ? null : new String(cArray, n3 + 1, cArray[n3] >> 1);
                    n3 += this.elementMaxLen;
                }
                break;
            }
            case 6: {
                objectArray = new BigDecimal[n2];
                byte[] byArray = this.statement.ibtBindBytes;
                for (int i = 0; i < n2; ++i) {
                    if (sArray[this.ibtIndicatorIndex + i] == -1) {
                        objectArray[i] = null;
                    } else {
                        byte by = byArray[n3];
                        byte[] byArray2 = new byte[by];
                        System.arraycopy(byArray, n3 + 1, byArray2, 0, by);
                        objectArray[i] = oracle.sql.NUMBER.toBigDecimal(byArray2);
                    }
                    n3 += this.elementMaxLen;
                }
                break;
            }
            default: {
                DatabaseError.throwSqlException(97);
            }
        }
        return objectArray;
    }

    Datum[] getOraclePlsqlIndexTable(int n) throws SQLException {
        Datum[] datumArray = null;
        short[] sArray = this.statement.ibtBindIndicators;
        int n2 = (sArray[this.ibtMetaIndex + 4] >> 16) + (sArray[this.ibtMetaIndex + 5] & 0xFFFF);
        int n3 = this.ibtValueIndex;
        switch (this.elementInternalType) {
            case 9: {
                datumArray = new CHAR[n2];
                CharacterSet characterSet = CharacterSet.make(2000);
                char[] cArray = this.statement.ibtBindChars;
                for (int i = 0; i < n2; ++i) {
                    if (sArray[this.ibtIndicatorIndex + i] == -1) {
                        datumArray[i] = null;
                    } else {
                        char c = cArray[n3];
                        byte[] byArray = new byte[c];
                        DBConversion.javaCharsToUcs2Bytes(cArray, n3 + 1, byArray, 0, c >> 1);
                        datumArray[i] = new CHAR(byArray, characterSet);
                    }
                    n3 += this.elementMaxLen;
                }
                break;
            }
            case 6: {
                datumArray = new NUMBER[n2];
                byte[] byArray = this.statement.ibtBindBytes;
                for (int i = 0; i < n2; ++i) {
                    if (sArray[this.ibtIndicatorIndex + i] == -1) {
                        datumArray[i] = null;
                    } else {
                        byte by = byArray[n3];
                        byte[] byArray2 = new byte[by];
                        System.arraycopy(byArray, n3 + 1, byArray2, 0, by);
                        datumArray[i] = new NUMBER(byArray2);
                    }
                    n3 += this.elementMaxLen;
                }
                break;
            }
            default: {
                DatabaseError.throwSqlException(97);
            }
        }
        return datumArray;
    }
}

