/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.indexed;

import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.disk.AbstractDiskCache;
import org.apache.jcs.auxiliary.disk.LRUMapJCS;
import org.apache.jcs.auxiliary.disk.indexed.IndexedDisk;
import org.apache.jcs.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.jcs.auxiliary.disk.indexed.IndexedDiskElementDescriptor;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.control.group.GroupAttrName;
import org.apache.jcs.engine.control.group.GroupId;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;
import org.apache.jcs.utils.struct.SortedPreferentialArray;

public class IndexedDiskCache
extends AbstractDiskCache {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$indexed$IndexedDiskCache == null ? (class$org$apache$jcs$auxiliary$disk$indexed$IndexedDiskCache = IndexedDiskCache.class$("org.apache.jcs.auxiliary.disk.indexed.IndexedDiskCache")) : class$org$apache$jcs$auxiliary$disk$indexed$IndexedDiskCache));
    private String fileName;
    private IndexedDisk dataFile;
    private IndexedDisk keyFile;
    private Map keyHash;
    private int maxKeySize;
    private File rafDir;
    boolean doRecycle = true;
    boolean isOptomizing = false;
    private LinkedList optimizingPutList = new LinkedList();
    private SortedPreferentialArray recycle;
    IndexedDiskCacheAttributes cattr;
    private int optCnt = 0;
    private int recycleCnt = 0;
    protected WriterPreferenceReadWriteLock storageLock = new WriterPreferenceReadWriteLock();
    private int timesOptimized = 0;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$indexed$IndexedDiskCache;

    public IndexedDiskCache(IndexedDiskCacheAttributes cattr) {
        super(cattr);
        String cacheName = cattr.getCacheName();
        String rootDirName = cattr.getDiskPath();
        this.maxKeySize = cattr.getMaxKeySize();
        this.cattr = cattr;
        this.fileName = cacheName;
        this.rafDir = new File(rootDirName);
        this.rafDir.mkdirs();
        log.info((Object)("Cache file root directory: " + rootDirName));
        try {
            this.dataFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".data"));
            this.keyFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".key"));
            if (this.keyFile.length() > 0L) {
                this.loadKeys();
                if (this.keyHash.size() == 0) {
                    this.dataFile.reset();
                } else {
                    boolean isOk = this.checkKeyDataConsistency();
                    if (!isOk) {
                        this.keyHash.clear();
                        this.keyFile.reset();
                        this.dataFile.reset();
                        log.warn((Object)"Corruption detected.  Reset data and keys files.");
                    }
                }
            } else {
                this.initKeyMap();
                if (this.dataFile.length() > 0L) {
                    this.dataFile.reset();
                }
            }
            this.initRecycleBin();
            this.alive = true;
        }
        catch (Exception e) {
            log.error((Object)("Failure initializing for fileName: " + this.fileName + " and root directory: " + rootDirName), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadKeys() throws InterruptedException {
        this.storageLock.writeLock().acquire();
        if (log.isInfoEnabled()) {
            log.info((Object)("loading keys for " + this.keyFile.toString()));
        }
        try {
            block8: {
                try {
                    this.initKeyMap();
                    HashMap keys = (HashMap)this.keyFile.readObject(0L);
                    if (keys != null) {
                        this.keyHash.putAll(keys);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Loaded keys from: " + this.fileName + ", key count: " + this.keyHash.size() + "; upto " + this.maxKeySize + " will be available."));
                        }
                    }
                    if (!log.isDebugEnabled()) break block8;
                    Iterator itr = this.keyHash.entrySet().iterator();
                    while (itr.hasNext()) {
                        Map.Entry e = itr.next();
                        String key = (String)e.getKey();
                        IndexedDiskElementDescriptor de = (IndexedDiskElementDescriptor)e.getValue();
                        log.debug((Object)("key entry: " + key + ", ded.pos" + de.pos + ", ded.len" + de.len));
                    }
                }
                catch (Exception e) {
                    log.error((Object)this.fileName, (Throwable)e);
                    Object var7_8 = null;
                    this.storageLock.writeLock().release();
                    return;
                }
            }
            Object var7_7 = null;
            this.storageLock.writeLock().release();
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.storageLock.writeLock().release();
            throw throwable;
        }
    }

    private boolean checkKeyDataConsistency() {
        log.info((Object)"Performing inital consistency check");
        boolean isOk = true;
        long len = 0L;
        try {
            len = this.dataFile.length();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        Iterator itr = this.keyHash.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            IndexedDiskElementDescriptor de = (IndexedDiskElementDescriptor)e.getValue();
            long pos = de.pos;
            if (pos > len) {
                isOk = false;
            }
            if (isOk) continue;
            log.warn((Object)("\n The dataFile is corrupted!\n raf.length() = " + len + "\n pos = " + pos));
            return isOk;
        }
        log.info((Object)("Finished inital consistency check, isOk = " + isOk));
        return isOk;
    }

    private void saveKeys() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving keys to: " + this.fileName + ", key count: " + this.keyHash.size()));
            }
            try {
                this.keyFile.reset();
                HashMap keys = new HashMap();
                keys.putAll(this.keyHash);
                if (keys.size() > 0) {
                    this.keyFile.writeObject(keys, 0L);
                }
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void doUpdate(ICacheElement ce) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Storing element on disk, key: " + ce.getKey()));
        }
        if (!this.alive) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Disk is not alive, aborting put.");
            }
            return;
        }
        IndexedDiskElementDescriptor ded = null;
        try {
            ded = new IndexedDiskElementDescriptor();
            byte[] data = IndexedDisk.serialize(ce);
            this.storageLock.writeLock().acquire();
            ded.init(this.dataFile.length(), data);
            try {
                IndexedDiskElementDescriptor old = this.keyHash.put(ce.getKey(), ded);
                if (old != null && ded.len <= old.len) {
                    ded.pos = old.pos;
                } else if (this.doRecycle) {
                    IndexedDiskElementDescriptor rep = (IndexedDiskElementDescriptor)this.recycle.takeNearestLargerOrEqual(ded);
                    if (rep != null) {
                        ded.pos = rep.pos;
                        ++this.recycleCnt;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("using recycled ded " + ded.pos + " rep.len = " + rep.len + " ded.len = " + ded.len));
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"no ded to recycle");
                    }
                }
                this.dataFile.write(data, ded.pos);
                if (this.isOptomizing) {
                    this.optimizingPutList.addLast(ce.getKey());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("added to optimizing put list." + this.optimizingPutList.size()));
                    }
                }
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.storageLock.writeLock().release();
                throw throwable;
            }
            this.storageLock.writeLock().release();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Put to file: " + this.fileName + ", key: " + ce.getKey() + ", position: " + ded.pos + ", size: " + ded.len));
            }
        }
        catch (ConcurrentModificationException cme) {
        }
        catch (Exception e) {
            log.error((Object)("Failure updating element, cacheName: " + this.cacheName + ", key: " + ce.getKey()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ICacheElement doGet(Serializable key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to get from disk: " + key));
        }
        CacheElement object = null;
        try {
            block8: {
                ICacheElement iCacheElement;
                block7: {
                    this.storageLock.readLock().acquire();
                    try {
                        if (!this.alive) {
                            log.debug((Object)("No longer alive so returning null, cacheName: " + this.cacheName + ", key = " + key));
                            iCacheElement = null;
                            Object var5_5 = null;
                            break block7;
                        }
                        object = this.readElement(key);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        this.storageLock.readLock().release();
                        throw throwable;
                    }
                }
                this.storageLock.readLock().release();
                return iCacheElement;
            }
            Object var5_6 = null;
            this.storageLock.readLock().release();
            return object;
        }
        catch (IOException ioe) {
            log.error((Object)("Failure getting from disk, cacheName: " + this.cacheName + ", key = " + key), (Throwable)ioe);
            this.reset();
            return object;
        }
        catch (Exception e) {
            log.error((Object)("Failure getting from disk, cacheName: " + this.cacheName + ", key = " + key), (Throwable)e);
        }
        return object;
    }

    private CacheElement readElement(Serializable key) throws IOException {
        CacheElement object = null;
        IndexedDiskElementDescriptor ded = (IndexedDiskElementDescriptor)this.keyHash.get(key);
        if (ded != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found on disk, key: " + key));
            }
            try {
                object = (CacheElement)this.dataFile.readObject(ded.pos);
            }
            catch (IOException e) {
                log.error((Object)"Problem reading object from file");
                throw e;
            }
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set getGroupKeys(String groupName) {
        GroupId groupId = new GroupId(this.cacheName, groupName);
        HashSet<Object> keys = new HashSet<Object>();
        try {
            try {
                this.storageLock.readLock().acquire();
                Iterator itr = this.keyHash.keySet().iterator();
                while (itr.hasNext()) {
                    Object k = itr.next();
                    if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(groupId)) continue;
                    keys.add(((GroupAttrName)k).attrName);
                }
            }
            catch (Exception e) {
                log.error((Object)("Failure getting from disk, cacheName: " + this.cacheName + ", group = " + groupName), (Throwable)e);
                Object var7_8 = null;
                this.storageLock.readLock().release();
                return keys;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.storageLock.readLock().release();
            throw throwable;
        }
        this.storageLock.readLock().release();
        return keys;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doRemove(Serializable key) {
        boolean reset;
        block19: {
            boolean ded22;
            block18: {
                ++this.optCnt;
                if (!this.isOptomizing && this.optCnt == this.cattr.getOptimizeAtRemoveCount()) {
                    this.doOptimizeRealTime();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("optCnt = " + this.optCnt));
                    }
                }
                reset = false;
                boolean removed = false;
                try {
                    try {
                        this.storageLock.writeLock().acquire();
                        if (key instanceof String && key.toString().endsWith(":")) {
                            Iterator iter = this.keyHash.entrySet().iterator();
                            while (true) {
                                IndexedDiskElementDescriptor ded;
                                if (!iter.hasNext()) break;
                                Map.Entry entry = iter.next();
                                Object k = entry.getKey();
                                if (!(k instanceof String) || !k.toString().startsWith(key.toString())) continue;
                                if (this.doRecycle && (ded = (IndexedDiskElementDescriptor)this.keyHash.get(key)) != null) {
                                    this.recycle.add(ded);
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("recycling ded " + ded));
                                    }
                                }
                                iter.remove();
                                removed = true;
                            }
                            boolean entry = removed;
                            Object var9_16 = null;
                            this.storageLock.writeLock().release();
                            return entry;
                        }
                        if (!(key instanceof GroupId)) {
                            IndexedDiskElementDescriptor ded22;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Disk removal: Removed from key hash, key " + key));
                            }
                            if (this.doRecycle && (ded22 = (IndexedDiskElementDescriptor)this.keyHash.get(key)) != null) {
                                this.recycle.add(ded22);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("recycling ded " + ded22));
                                }
                            }
                            ded22 = this.keyHash.remove(key) != null;
                            break block18;
                        }
                        Iterator iter = this.keyHash.entrySet().iterator();
                        while (iter.hasNext()) {
                            IndexedDiskElementDescriptor ded;
                            Map.Entry entry = iter.next();
                            Object k = entry.getKey();
                            if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(key)) continue;
                            if (this.doRecycle && (ded = (IndexedDiskElementDescriptor)this.keyHash.get(key)) != null) {
                                this.recycle.add(ded);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("recycling ded " + ded));
                                }
                            }
                            iter.remove();
                            removed = true;
                        }
                        Object var9_18 = null;
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                        reset = true;
                        Object var9_19 = null;
                        this.storageLock.writeLock().release();
                        break block19;
                    }
                    this.storageLock.writeLock().release();
                    break block19;
                }
                catch (Throwable throwable) {
                    Object var9_20 = null;
                    this.storageLock.writeLock().release();
                    throw throwable;
                }
            }
            Object var9_17 = null;
            this.storageLock.writeLock().release();
            return ded22;
        }
        if (reset) {
            this.reset();
        }
        return false;
    }

    public void doRemoveAll() {
        try {
            try {
                this.reset();
            }
            catch (Exception e) {
                log.error((Object)e);
                this.reset();
                Object var3_2 = null;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reset() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Reseting cache");
        }
        try {
            try {
                this.storageLock.writeLock().acquire();
                this.dataFile.close();
                File file = new File(this.rafDir, this.fileName + ".data");
                file.delete();
                this.keyFile.close();
                File file2 = new File(this.rafDir, this.fileName + ".key");
                file2.delete();
                this.dataFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".data"));
                this.keyFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".key"));
                this.initRecycleBin();
                this.initKeyMap();
            }
            catch (Exception e) {
                log.error((Object)"Failure reseting state", (Throwable)e);
                Object var4_5 = null;
                this.storageLock.writeLock().release();
                return;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.storageLock.writeLock().release();
            throw throwable;
        }
        this.storageLock.writeLock().release();
    }

    private void initRecycleBin() {
        this.recycle = null;
        if (this.cattr.getMaxRecycleBinSize() >= 0) {
            this.recycle = new SortedPreferentialArray(this.cattr.getMaxRecycleBinSize());
            if (log.isInfoEnabled()) {
                log.info((Object)("Set recycle max Size to MaxRecycleBinSize: '" + this.cattr.getMaxRecycleBinSize() + "'"));
            }
        } else {
            this.recycle = new SortedPreferentialArray(0);
            if (log.isInfoEnabled()) {
                log.warn((Object)"Set recycle maxSize to 0, will not try to recycle, MaxRecycleBinSize was less than 0");
            }
        }
    }

    private void initKeyMap() {
        this.keyHash = null;
        if (this.maxKeySize >= 0) {
            this.keyHash = new LRUMapJCS(this.maxKeySize);
            if (log.isInfoEnabled()) {
                log.info((Object)("Set maxKeySize to: '" + this.maxKeySize + "'"));
            }
        } else {
            this.keyHash = new HashMap();
            if (log.isInfoEnabled()) {
                log.info((Object)"Set maxKeySize to unlimited'");
            }
        }
    }

    public void doDispose() {
        Runnable disR = new Runnable(){

            public void run() {
                IndexedDiskCache.this.disposeInternal();
            }
        };
        Thread t = new Thread(disR);
        t.start();
        try {
            t.join(60000L);
        }
        catch (InterruptedException ex) {
            log.error((Object)ex);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void disposeInternal() {
        try {
            block14: {
                this.storageLock.writeLock().acquire();
                if (this.alive) break block14;
                IndexedDiskCache.log.debug((Object)("Not alive and dispose was called, filename: " + this.fileName));
                var3_1 = null;
                this.alive = false;
                ** GOTO lbl48
            }
            try {
                this.optimizeFile();
            }
            catch (Exception e) {
                IndexedDiskCache.log.error((Object)this.fileName, (Throwable)e);
            }
            try {
                IndexedDiskCache.log.warn((Object)("Closing files, base filename: " + this.fileName));
                this.dataFile.close();
                this.dataFile = null;
                this.keyFile.close();
                this.keyFile = null;
            }
            catch (Exception e) {
                IndexedDiskCache.log.error((Object)("Failure closing files in dispose, filename: " + this.fileName), (Throwable)e);
            }
            ** GOTO lbl54
        }
        catch (Exception e) {
            IndexedDiskCache.log.error((Object)"Failure in dispose", (Throwable)e);
            var3_3 = null;
            this.alive = false;
            try {
                this.storageLock.writeLock().release();
                return;
            }
            catch (Exception e) {
                IndexedDiskCache.log.error((Object)("Failure releasing lock on shutdown " + e));
                return;
            }
        }
        {
            catch (Throwable var2_12) {
                var3_4 = null;
                this.alive = false;
                ** try [egrp 4[TRYBLOCK] [4 : 199->214)] { 
lbl43:
                // 1 sources

                this.storageLock.writeLock().release();
                throw var2_12;
lbl45:
                // 1 sources

                catch (Exception e) {
                    IndexedDiskCache.log.error((Object)("Failure releasing lock on shutdown " + e));
                }
                throw var2_12;
            }
lbl48:
            // 1 sources

            ** try [egrp 4[TRYBLOCK] [4 : 199->214)] { 
lbl49:
            // 1 sources

            this.storageLock.writeLock().release();
            return;
lbl51:
            // 1 sources

            catch (Exception e) {
                IndexedDiskCache.log.error((Object)("Failure releasing lock on shutdown " + e));
            }
            return;
lbl54:
            // 2 sources

            var3_2 = null;
            this.alive = false;
            try {}
            catch (Exception e) {}
            IndexedDiskCache.log.error((Object)("Failure releasing lock on shutdown " + e));
            return;
            this.storageLock.writeLock().release();
            return;
        }
    }

    public synchronized void doOptimizeRealTime() {
        if (!this.isOptomizing) {
            this.isOptomizing = true;
            Runnable optR = new Runnable(){

                public void run() {
                    IndexedDiskCache.this.optimizeRealTime();
                }
            };
            Thread t = new Thread(optR);
            t.start();
        }
    }

    private void optimizeRealTime() {
        long start = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)("Beginning Real Time Optimization #" + ++this.timesOptimized));
        }
        Object[] keys = null;
        try {
            Serializable key;
            this.storageLock.readLock().acquire();
            try {
                keys = this.keyHash.keySet().toArray();
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.storageLock.readLock().release();
                throw throwable;
            }
            this.storageLock.readLock().release();
            LRUMap keyHashTemp = new LRUMap(this.maxKeySize);
            keyHashTemp.tag = "Round=" + this.timesOptimized;
            IndexedDisk dataFileTemp = new IndexedDisk(new File(this.rafDir, this.fileName + "Temp.data"));
            this.isOptomizing = true;
            int len = keys.length;
            if (log.isInfoEnabled()) {
                log.info((Object)("Optimizing RT -- TempKeys, length = " + len));
            }
            int i = 0;
            while (i < len) {
                Object var10_13;
                this.storageLock.writeLock().acquire();
                try {
                    key = (Serializable)keys[i];
                    this.moveKeyDataToTemp(key, keyHashTemp, dataFileTemp);
                    var10_13 = null;
                }
                catch (Throwable throwable) {
                    var10_13 = null;
                    this.storageLock.writeLock().release();
                    throw throwable;
                }
                this.storageLock.writeLock().release();
                ++i;
            }
            this.storageLock.writeLock().acquire();
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Optimizing RT -- PutList, size = " + this.optimizingPutList.size()));
                }
                while (this.optimizingPutList.size() > 0) {
                    key = (Serializable)this.optimizingPutList.removeFirst();
                    this.moveKeyDataToTemp(key, keyHashTemp, dataFileTemp);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("keyHashTemp, size = " + keyHashTemp.size()));
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)"Optimizing RT -- Replacing Files");
                }
                this.tempToPrimary(keyHashTemp, dataFileTemp);
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                this.storageLock.writeLock().release();
                throw throwable;
            }
            this.storageLock.writeLock().release();
            {
            }
        }
        catch (Exception e) {
            log.error((Object)("Failure Optimizing RealTime, cacheName: " + this.cacheName), (Throwable)e);
        }
        this.optCnt = 0;
        this.isOptomizing = false;
        long end = System.currentTimeMillis();
        long time = end - start;
        if (log.isInfoEnabled()) {
            log.info((Object)("Finished #" + this.timesOptimized + " Real Time Optimization in " + time + " millis."));
        }
    }

    private void optimizeFile() {
        try {
            LRUMap keyHashTemp = new LRUMap(this.maxKeySize);
            IndexedDisk dataFileTemp = new IndexedDisk(new File(this.rafDir, this.fileName + "Temp.data"));
            if (log.isInfoEnabled()) {
                log.info((Object)("Optomizing file keyHash.size()=" + this.keyHash.size()));
            }
            Object[] keys = this.keyHash.keySet().toArray();
            int len = keys.length;
            try {
                int i = 0;
                while (i < len) {
                    Serializable key = (Serializable)keys[i];
                    this.moveKeyDataToTemp(key, keyHashTemp, dataFileTemp);
                    ++i;
                }
                this.tempToPrimary(keyHashTemp, dataFileTemp);
            }
            catch (IOException e) {
                log.error((Object)"Problem in optimization, abandoning attempt");
            }
        }
        catch (Exception e) {
            log.error((Object)this.fileName, (Throwable)e);
        }
    }

    private void moveKeyDataToTemp(Serializable key, LRUMap keyHashTemp, IndexedDisk dataFileTemp) throws Exception {
        CacheElement tempDe = null;
        try {
            tempDe = this.readElement(key);
        }
        catch (IOException e) {
            log.error((Object)("Failed to get orinigal off disk cache: " + this.fileName + ", key: " + key + ""));
            throw e;
        }
        try {
            IndexedDiskElementDescriptor ded = new IndexedDiskElementDescriptor();
            byte[] data = IndexedDisk.serialize(tempDe);
            ded.init(dataFileTemp.length(), data);
            dataFileTemp.write(data, ded.pos);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Optomize: Put to temp disk cache: " + this.fileName + ", key: " + key + ", ded.pos:" + ded.pos + ", ded.len:" + ded.len));
            }
            keyHashTemp.put(key, ded);
        }
        catch (Exception e) {
            log.error((Object)("Failed to put to temp disk cache: " + this.fileName + ", key: " + key), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.fileName + " -- keyHashTemp.size(): " + keyHashTemp.size() + ", keyHash.size(): " + this.keyHash.size()));
        }
    }

    private void tempToPrimary(LRUMap keyHashTemp, IndexedDisk dataFileTemp) {
        try {
            dataFileTemp.close();
            this.dataFile.close();
            File oldData = new File(this.rafDir, this.fileName + ".data");
            if (oldData.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)(this.fileName + " -- oldData.length() = " + oldData.length()));
                }
                oldData.delete();
            }
            File newData = new File(this.rafDir, this.fileName + "Temp.data");
            File newFileName = new File(this.rafDir, this.fileName + ".data");
            if (newData.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)(this.fileName + " -- newData.length() = " + newData.length()));
                }
                boolean success = newData.renameTo(newFileName);
                if (log.isInfoEnabled()) {
                    log.info((Object)(" rename success = " + success));
                }
            }
            this.dataFile = new IndexedDisk(newFileName);
            if (log.isInfoEnabled()) {
                log.info((Object)("1 dataFile.length() " + this.dataFile.length()));
            }
            this.keyHash = keyHashTemp;
            this.keyFile.reset();
            this.saveKeys();
            this.recycle = null;
            this.recycle = new SortedPreferentialArray(this.maxKeySize);
        }
        catch (Exception e) {
            log.error((Object)"Failed to put to temp disk cache", (Throwable)e);
        }
    }

    public int getSize() {
        return this.keyHash.size();
    }

    public void dump() {
        log.debug((Object)("[dump] Number of keys: " + this.keyHash.size()));
        Iterator itr = this.keyHash.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            Serializable key = (Serializable)e.getKey();
            IndexedDiskElementDescriptor ded = (IndexedDiskElementDescriptor)e.getValue();
            ICacheElement val = this.get(key);
            log.debug((Object)("[dump] Disk element, key: " + key + ", val: " + val + ", pos: " + ded.pos));
        }
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Indexed Disk Cache");
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Is Alive");
        se.setData("" + this.alive);
        elems.add(se);
        se = new StatElement();
        se.setName("Key Map Size");
        if (this.keyHash != null) {
            se.setData("" + this.keyHash.size());
        } else {
            se.setData("-1");
        }
        elems.add(se);
        try {
            se = new StatElement();
            se.setName("Data File Length");
            if (this.dataFile != null) {
                se.setData("" + this.dataFile.length());
            } else {
                se.setData("-1");
            }
            elems.add(se);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        se = new StatElement();
        se.setName("Optimize Opertaion Count");
        se.setData("" + this.optCnt);
        elems.add(se);
        se = new StatElement();
        se.setName("Times Optimized");
        se.setData("" + this.timesOptimized);
        elems.add(se);
        se = new StatElement();
        se.setName("Recycle Count");
        se.setData("" + this.recycleCnt);
        elems.add(se);
        IStats sStats = super.getStatistics();
        IStatElement[] sSEs = sStats.getStatElements();
        List<IStatElement> sL = Arrays.asList(sSEs);
        elems.addAll(sL);
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class LRUMap
    extends LRUMapJCS {
        public String tag = "orig";

        public LRUMap() {
        }

        public LRUMap(int maxKeySize) {
            super(maxKeySize);
        }

        protected void processRemovedLRU(Object key, Object value) {
            IndexedDiskElementDescriptor ded;
            if (IndexedDiskCache.this.doRecycle && (ded = (IndexedDiskElementDescriptor)value) != null) {
                IndexedDiskCache.this.recycle.add(ded);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("recycled ded in LRU" + ded));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing key: '" + key + "' from key store."));
                log.debug((Object)("Key store size: '" + this.size() + "'."));
            }
        }
    }
}

