/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.taglib.IterationTag;
import org.apache.cocoon.taglib.Tag;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.xml.AbstractXMLProducer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.collections.map.StaticBucketMap;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class TagTransformer
extends AbstractXMLProducer
implements Transformer,
Serviceable,
Configurable,
Disposable,
Recyclable {
    private int recordingLevel = 0;
    private int skipLevel = 0;
    private String transformerHint;
    private ArrayStack tagStack = new ArrayStack();
    private ArrayStack tagSelectorStack = new ArrayStack();
    private ArrayStack tagTransformerStack = new ArrayStack();
    private ServiceSelector tagNamespaceSelector;
    private ServiceSelector transformerSelector;
    private Tag currentTag;
    private XMLConsumer currentConsumer;
    private XMLConsumer currentConsumerBackup;
    private XMLSerializer xmlSerializer;
    private SourceResolver resolver;
    private Map objectModel;
    private Parameters parameters;
    private ServiceManager manager;
    private String[] paramArray = new String[1];
    private static Map writeMethodMap = new StaticBucketMap();
    static /* synthetic */ Class class$java$lang$String;

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.characters(ch, start, length);
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.comment(ch, start, length);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.tagNamespaceSelector = (ServiceSelector)manager.lookup(Tag.ROLE + "Selector");
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.transformerHint = conf.getChild("transformer-hint").getValue(null);
        if (this.transformerHint != null) {
            try {
                this.transformerSelector = (ServiceSelector)this.manager.lookup(Transformer.ROLE + "Selector");
            }
            catch (ServiceException e) {
                String message = "can't lookup transformer";
                this.getLogger().error(message, (Throwable)e);
                throw new ConfigurationException(message, (Throwable)e);
            }
        }
    }

    public void endCDATA() throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.endCDATA();
    }

    public void endDocument() throws SAXException {
        this.currentConsumer.endDocument();
        this.getLogger().debug("endDocument");
    }

    public void endDTD() throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.endDTD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Tag tag;
        Object saxFragment = null;
        if (this.recordingLevel > 0) {
            if (--this.recordingLevel > 0) {
                this.currentConsumer.endElement(namespaceURI, localName, qName);
                return;
            }
            this.currentConsumer = this.currentConsumerBackup;
            saxFragment = this.xmlSerializer.getSAXFragment();
            this.manager.release((Object)this.xmlSerializer);
            this.xmlSerializer = null;
        }
        if (this.skipLevel > 0) {
            --this.skipLevel;
            if (this.skipLevel > 0) {
                return;
            }
        }
        if ((tag = (Tag)this.tagStack.pop()) == null) {
            this.currentConsumer.endElement(namespaceURI, localName, qName);
            return;
        }
        ServiceSelector tagSelector = (ServiceSelector)this.tagSelectorStack.pop();
        try {
            block17: {
                if (saxFragment != null) {
                    IterationTag iterTag = (IterationTag)tag;
                    XMLDeserializer xmlDeserializer = null;
                    try {
                        try {
                            xmlDeserializer = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
                            xmlDeserializer.setConsumer((XMLConsumer)this);
                            do {
                                xmlDeserializer.deserialize(saxFragment);
                            } while (iterTag.doAfterBody() != 1);
                        }
                        catch (ServiceException e) {
                            throw new SAXException("lookup XMLDeserializer failed", (Exception)((Object)e));
                        }
                        Object var11_9 = null;
                        if (xmlDeserializer == null) break block17;
                    }
                    catch (Throwable throwable) {
                        Object var11_10 = null;
                        if (xmlDeserializer == null) throw throwable;
                        this.manager.release((Object)xmlDeserializer);
                        throw throwable;
                    }
                    this.manager.release((Object)xmlDeserializer);
                }
            }
            tag.doEndTag(namespaceURI, localName, qName);
            this.currentTag = tag.getParent();
            if (tag != this.currentConsumer) return;
            Tag loop = this.currentTag;
            while (loop != null && !(loop instanceof XMLConsumer)) {
                loop = loop.getParent();
            }
            if (loop != null) {
                this.currentConsumer = (XMLConsumer)loop;
                return;
            }
            this.currentConsumer = this.xmlConsumer;
            return;
        }
        finally {
            this.getLogger().debug("endElement: release Tag");
            tagSelector.release((Object)tag);
            this.tagNamespaceSelector.release((Object)tagSelector);
            if (this.transformerSelector != null && tag instanceof XMLProducer) {
                this.getLogger().debug("endElement: release transformer");
                Transformer transformer = (Transformer)this.tagTransformerStack.pop();
                this.transformerSelector.release((Object)transformer);
            }
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.endEntity(name);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.endPrefixMapping(prefix);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.processingInstruction(target, data);
    }

    public void recycle() {
        this.recordingLevel = 0;
        this.skipLevel = 0;
        this.resolver = null;
        this.objectModel = null;
        this.parameters = null;
        this.currentTag = null;
        this.currentConsumer = null;
        this.currentConsumerBackup = null;
        if (this.xmlSerializer != null) {
            this.manager.release((Object)this.xmlSerializer);
            this.xmlSerializer = null;
        }
        while (!this.tagStack.isEmpty()) {
            Tag tag = (Tag)this.tagStack.pop();
            if (tag == null) continue;
            ServiceSelector tagSelector = (ServiceSelector)this.tagSelectorStack.pop();
            tagSelector.release((Object)tag);
            this.tagNamespaceSelector.release((Object)tagSelector);
        }
        while (!this.tagTransformerStack.isEmpty()) {
            Transformer transformer = (Transformer)this.tagTransformerStack.pop();
            this.transformerSelector.release((Object)transformer);
        }
        if (!this.tagSelectorStack.isEmpty()) {
            this.getLogger().fatalError("recycle: internal Error, tagSelectorStack not empty");
            this.tagSelectorStack.clear();
        }
        super.recycle();
    }

    public void setConsumer(XMLConsumer consumer) {
        this.currentConsumer = consumer;
        super.setConsumer(consumer);
    }

    public void setDocumentLocator(Locator locator) {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.setDocumentLocator(locator);
    }

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws IOException, SAXException {
        this.resolver = resolver;
        this.objectModel = objectModel;
        this.parameters = parameters;
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.skippedEntity(name);
    }

    public void startCDATA() throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.startCDATA();
    }

    public void startDocument() throws SAXException {
        this.currentConsumer.startDocument();
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.startDTD(name, publicId, systemId);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.recordingLevel > 0) {
            ++this.recordingLevel;
            this.currentConsumer.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        if (this.skipLevel > 0) {
            ++this.skipLevel;
            return;
        }
        Tag tag = null;
        if (namespaceURI != null && namespaceURI.length() > 0) {
            ServiceSelector tagSelector = null;
            Transformer tagTransformer = null;
            try {
                tagSelector = (ServiceSelector)this.tagNamespaceSelector.select((Object)namespaceURI);
                this.tagSelectorStack.push((Object)tagSelector);
                tag = (Tag)tagSelector.select((Object)localName);
                tag.setParent(this.currentTag);
                tag.setup(this.resolver, this.objectModel, this.parameters);
                if (tag instanceof XMLProducer && this.transformerSelector != null) {
                    tagTransformer = (Transformer)this.transformerSelector.select((Object)this.transformerHint);
                    this.tagTransformerStack.push((Object)tagTransformer);
                    tagTransformer.setup(this.resolver, this.objectModel, null, this.parameters);
                    ((XMLProducer)tag).setConsumer((XMLConsumer)tagTransformer);
                    tagTransformer.setConsumer(this.currentConsumer);
                }
                if (tag instanceof XMLConsumer) {
                    this.currentConsumer = (XMLConsumer)tag;
                }
                this.currentTag = tag;
                int i = 0;
                while (i < atts.getLength()) {
                    block18: {
                        String attributeValue;
                        String attributeName = atts.getLocalName(i);
                        this.paramArray[0] = attributeValue = atts.getValue(i);
                        try {
                            Method method = TagTransformer.getWriteMethod(tag.getClass(), attributeName);
                            method.invoke((Object)tag, (Object[])this.paramArray);
                        }
                        catch (Throwable e) {
                            if (!this.getLogger().isInfoEnabled()) break block18;
                            this.getLogger().info("startElement(" + localName + "): Attribute " + attributeName + " not set", e);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        this.tagStack.push(tag);
        if (tag == null) {
            this.currentConsumer.startElement(namespaceURI, localName, qName, atts);
        } else {
            int eval = tag.doStartTag(namespaceURI, localName, qName, atts);
            switch (eval) {
                case 0: {
                    this.skipLevel = 0;
                    if (!(tag instanceof IterationTag)) break;
                    try {
                        this.xmlSerializer = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
                        this.currentConsumerBackup = this.currentConsumer;
                        this.currentConsumer = this.xmlSerializer;
                        this.recordingLevel = 1;
                        break;
                    }
                    catch (ServiceException e) {
                        throw new SAXException("lookup XMLSerializer failed", (Exception)((Object)e));
                    }
                }
                case 1: {
                    this.skipLevel = 1;
                    break;
                }
                default: {
                    String tagName = tag.getClass().getName();
                    this.getLogger().warn("Bad return value from doStartTag(" + tagName + "): " + eval);
                }
            }
        }
    }

    public void startEntity(String name) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.startEntity(name);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.startPrefixMapping(prefix, uri);
    }

    public void dispose() {
        this.manager.release((Object)this.tagNamespaceSelector);
        this.tagNamespaceSelector = null;
        if (this.transformerSelector != null) {
            this.manager.release((Object)this.transformerSelector);
            this.transformerSelector = null;
        }
    }

    private static Method getWriteMethod(Class type, String propertyName) throws IntrospectionException {
        Map map = TagTransformer.getWriteMethodMap(type);
        Method method = (Method)map.get(propertyName);
        if (method == null) {
            throw new IntrospectionException("No such property: " + propertyName);
        }
        return method;
    }

    private static Map getWriteMethodMap(Class beanClass) throws IntrospectionException {
        HashMap<String, Method> map = (HashMap<String, Method>)writeMethodMap.get(beanClass);
        if (map != null) {
            return map;
        }
        BeanInfo info = Introspector.getBeanInfo(beanClass);
        if (info != null) {
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            map = new HashMap<String, Method>(pds.length * 4 / 3, 1.0f);
            int i = 0;
            while (i < pds.length) {
                PropertyDescriptor pd = pds[i];
                String name = pd.getName();
                Method method = pd.getWriteMethod();
                Class<?> type = pd.getPropertyType();
                if (type == (class$java$lang$String == null ? TagTransformer.class$("java.lang.String") : class$java$lang$String)) {
                    map.put(name, method);
                }
                ++i;
            }
        }
        writeMethodMap.put(beanClass, map);
        return map;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

