/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.render.ps.PSFontUtils;
import org.apache.fop.render.ps.PSImageFormResource;
import org.apache.fop.render.ps.PSImageUtils;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.ps.dsc.DSCException;
import org.apache.xmlgraphics.ps.dsc.DSCFilter;
import org.apache.xmlgraphics.ps.dsc.DSCParser;
import org.apache.xmlgraphics.ps.dsc.DSCParserConstants;
import org.apache.xmlgraphics.ps.dsc.DefaultNestedDocumentHandler;
import org.apache.xmlgraphics.ps.dsc.NestedDocumentHandler;
import org.apache.xmlgraphics.ps.dsc.ResourceTracker;
import org.apache.xmlgraphics.ps.dsc.events.DSCComment;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentDocumentNeededResources;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentDocumentSuppliedResources;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentLanguageLevel;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentPage;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentPages;
import org.apache.xmlgraphics.ps.dsc.events.DSCEvent;
import org.apache.xmlgraphics.ps.dsc.events.DSCHeaderComment;
import org.apache.xmlgraphics.ps.dsc.events.PostScriptComment;
import org.apache.xmlgraphics.ps.dsc.tools.DSCTools;

public class ResourceHandler
implements DSCParserConstants {
    public static void process(FOUserAgent userAgent, InputStream in, OutputStream out, FontInfo fontInfo, ResourceTracker resTracker, Map formResources, int pageCount) throws DSCException, IOException {
        DSCEvent event;
        DSCParser parser = new DSCParser(in);
        PSGenerator gen = new PSGenerator(out);
        parser.setNestedDocumentHandler((NestedDocumentHandler)new DefaultNestedDocumentHandler(gen));
        DSCHeaderComment header = DSCTools.checkAndSkipDSC30Header((DSCParser)parser);
        header.generate(gen);
        parser.setFilter(new DSCFilter(){
            private final Set filtered = new HashSet();
            {
                this.filtered.add("Pages");
                this.filtered.add("DocumentNeededResources");
                this.filtered.add("DocumentSuppliedResources");
            }

            public boolean accept(DSCEvent event) {
                if (event.isDSCComment()) {
                    return !this.filtered.contains(event.asDSCComment().getName());
                }
                return true;
            }
        });
        while (true) {
            DSCComment comment;
            if ((event = parser.nextEvent()) == null) {
                ResourceHandler.reportInvalidDSC();
            }
            if (DSCTools.headerCommentsEndHere((DSCEvent)event)) break;
            if (event.isDSCComment() && "LanguageLevel".equals((comment = event.asDSCComment()).getName())) {
                DSCCommentLanguageLevel level = (DSCCommentLanguageLevel)comment;
                gen.setPSLevel(level.getLanguageLevel());
            }
            event.generate(gen);
        }
        DSCCommentPages pages = new DSCCommentPages(pageCount);
        pages.generate(gen);
        PSFontUtils.determineSuppliedFonts(resTracker, fontInfo, fontInfo.getUsedFonts());
        ResourceHandler.registerSuppliedForms(resTracker, formResources);
        DSCCommentDocumentSuppliedResources supplied = new DSCCommentDocumentSuppliedResources((Collection)resTracker.getDocumentSuppliedResources());
        supplied.generate(gen);
        DSCCommentDocumentNeededResources needed = new DSCCommentDocumentNeededResources((Collection)resTracker.getDocumentNeededResources());
        needed.generate(gen);
        event.generate(gen);
        PostScriptComment fontSetupPlaceholder = parser.nextPSComment("FOPFontSetup", gen);
        if (fontSetupPlaceholder == null) {
            throw new DSCException("Didn't find %FOPFontSetup comment in stream");
        }
        PSFontUtils.writeFontDict(gen, fontInfo, fontInfo.getUsedFonts());
        ResourceHandler.generateForms(resTracker, userAgent, formResources, gen);
        DSCComment pageOrTrailer = parser.nextDSCComment("Page", gen);
        if (pageOrTrailer == null) {
            throw new DSCException("Page expected, but none found");
        }
        while (true) {
            DSCCommentPage page = (DSCCommentPage)pageOrTrailer;
            page.generate(gen);
            pageOrTrailer = DSCTools.nextPageOrTrailer((DSCParser)parser, (PSGenerator)gen);
            if (pageOrTrailer == null) {
                ResourceHandler.reportInvalidDSC();
                continue;
            }
            if (!"Page".equals(pageOrTrailer.getName())) break;
        }
        pageOrTrailer.generate(gen);
        while (parser.hasNext()) {
            DSCEvent event2 = parser.nextEvent();
            event2.generate(gen);
        }
    }

    private static void reportInvalidDSC() throws DSCException {
        throw new DSCException("File is not DSC-compliant: Unexpected end of file");
    }

    private static void registerSuppliedForms(ResourceTracker resTracker, Map formResources) throws IOException {
        if (formResources == null) {
            return;
        }
        Iterator iter = formResources.values().iterator();
        while (iter.hasNext()) {
            PSImageFormResource form = (PSImageFormResource)((Object)iter.next());
            resTracker.registerSuppliedResource((PSResource)form);
        }
    }

    private static void generateForms(ResourceTracker resTracker, FOUserAgent userAgent, Map formResources, PSGenerator gen) throws IOException {
        if (formResources == null) {
            return;
        }
        Iterator iter = formResources.values().iterator();
        while (iter.hasNext()) {
            PSImageFormResource form = (PSImageFormResource)((Object)iter.next());
            ImageFactory fact = userAgent.getFactory().getImageFactory();
            FopImage image = fact.getImage(form.getImageURI(), userAgent);
            if (image == null) {
                throw new NullPointerException("Image not found: " + form.getImageURI());
            }
            PSImageUtils.generateFormResourceForImage(image, form, gen);
        }
    }
}

