/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util.log;

import org.apache.avalon.excalibur.logger.factory.FileTargetFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.cocoon.util.log.CocoonLogFormatter;
import org.apache.cocoon.util.log.XMLCocoonLogFormatter;
import org.apache.log.format.Formatter;

public class CocoonTargetFactory
extends FileTargetFactory {
    private static final String CFORMAT = "%7.7{priority} %{time}   [%8.8{category}] (%{uri}) %{thread}/%{class:short}: %{message}\\n%{throwable}";
    private static final String XFORMAT = "priority time category uri thread class message throwable";

    protected Formatter getFormatter(Configuration conf) {
        String type = conf.getAttribute("type", "unknown");
        if ("cocoon".equals(type)) {
            int depth = conf.getAttributeAsInteger("depth", 0);
            CocoonLogFormatter formatter = new CocoonLogFormatter(depth);
            String format = conf.getValue(CFORMAT);
            formatter.setFormat(format);
            return formatter;
        }
        if ("xml".equals(type)) {
            XMLCocoonLogFormatter formatter = new XMLCocoonLogFormatter();
            String format = conf.getValue(XFORMAT);
            formatter.setTypes(format);
            return formatter;
        }
        return super.getFormatter(conf);
    }
}

