/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ConfigurationUtil {
    private ConfigurationUtil() {
    }

    public static Configuration toConfiguration(Element element) {
        DefaultConfiguration configuration = new DefaultConfiguration(element.getLocalName(), element.getPrefix(), element.getNamespaceURI(), element.getPrefix());
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = attributes.item(i);
            String name = node.getNodeName();
            String value = node.getNodeValue();
            configuration.setAttribute(name, value);
        }
        boolean flag = false;
        String content = "";
        NodeList nodes = element.getChildNodes();
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                Configuration child = ConfigurationUtil.toConfiguration((Element)node);
                configuration.addChild(child);
                continue;
            }
            if (!(node instanceof CharacterData)) continue;
            CharacterData data = (CharacterData)node;
            content = content + data.getData();
            flag = true;
        }
        if (flag) {
            configuration.setValue(content);
        }
        return configuration;
    }

    public static Element toElement(Configuration configuration) throws ConfigurationException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            return ConfigurationUtil.createElement(document, configuration);
        }
        catch (ParserConfigurationException pce) {
            throw new IllegalStateException(pce.toString());
        }
    }

    private static Element createElement(Document document, Configuration configuration) throws ConfigurationException {
        Element element = document.createElementNS(configuration.getNamespace(), configuration.getName());
        element.setPrefix(configuration.getLocation());
        String content = configuration.getValue(null);
        if (null != content) {
            Text child = document.createTextNode(content);
            element.appendChild(child);
        }
        String[] names = configuration.getAttributeNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String value = configuration.getAttribute(name, null);
            element.setAttribute(name, value);
        }
        Configuration[] children = configuration.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Element child = ConfigurationUtil.createElement(document, children[i]);
            element.appendChild(child);
        }
        return element;
    }
}

