/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.multipart;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cocoon.servlet.multipart.MultipartException;
import org.apache.cocoon.servlet.multipart.PartInMemory;
import org.apache.cocoon.servlet.multipart.PartOnDisk;
import org.apache.cocoon.servlet.multipart.RejectedPart;
import org.apache.cocoon.servlet.multipart.TokenStream;
import org.apache.cocoon.util.NullOutputStream;

public class MultipartParser {
    public static final String UPLOAD_STATUS_SESSION_ATTR = "org.apache.cocoon.servlet.multipartparser.status";
    private static final int FILE_BUFFER_SIZE = 4096;
    private static final int MAX_BOUNDARY_SIZE = 128;
    private boolean saveUploadedFilesToDisk;
    private File uploadDirectory = null;
    private boolean allowOverwrite;
    private boolean silentlyRename;
    private int maxUploadSize;
    private String characterEncoding;
    private Hashtable parts;
    private boolean oversized = false;
    private int contentLength;
    private HttpSession session;
    private boolean hasSession;
    private Hashtable uploadStatus;

    public MultipartParser(boolean saveUploadedFilesToDisk, File uploadDirectory, boolean allowOverwrite, boolean silentlyRename, int maxUploadSize, String characterEncoding) {
        this.saveUploadedFilesToDisk = saveUploadedFilesToDisk;
        this.uploadDirectory = uploadDirectory;
        this.allowOverwrite = allowOverwrite;
        this.silentlyRename = silentlyRename;
        this.maxUploadSize = maxUploadSize;
        this.characterEncoding = characterEncoding;
    }

    private void parseParts(int contentLength, String contentType, InputStream requestStream) throws IOException, MultipartException {
        this.contentLength = contentLength;
        if (contentLength > this.maxUploadSize) {
            this.oversized = true;
        }
        BufferedInputStream bufferedStream = new BufferedInputStream(requestStream);
        PushbackInputStream pushbackStream = new PushbackInputStream(bufferedStream, 128);
        TokenStream stream = new TokenStream(pushbackStream);
        this.parseMultiPart(stream, this.getBoundary(contentType));
    }

    public Hashtable getParts(int contentLength, String contentType, InputStream requestStream) throws IOException, MultipartException {
        this.parts = new Hashtable();
        this.parseParts(contentLength, contentType, requestStream);
        return this.parts;
    }

    public Hashtable getParts(HttpServletRequest request) throws IOException, MultipartException {
        this.parts = new Hashtable();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String[] values = request.getParameterValues(name);
            Vector<String> v = new Vector<String>(values.length);
            for (int i = 0; i < values.length; ++i) {
                v.add(values[i]);
            }
            this.parts.put(name, v);
        }
        this.session = request.getSession();
        boolean bl = this.hasSession = this.session != null;
        if (this.hasSession) {
            this.uploadStatus = new Hashtable();
            this.uploadStatus.put("started", Boolean.FALSE);
            this.uploadStatus.put("finished", Boolean.FALSE);
            this.uploadStatus.put("sent", new Integer(0));
            this.uploadStatus.put("total", new Integer(request.getContentLength()));
            this.uploadStatus.put("filename", "");
            this.uploadStatus.put("error", Boolean.FALSE);
            this.uploadStatus.put("uploadsdone", new Integer(0));
            this.session.setAttribute(UPLOAD_STATUS_SESSION_ATTR, (Object)this.uploadStatus);
        }
        this.parseParts(request.getContentLength(), request.getContentType(), (InputStream)request.getInputStream());
        if (this.hasSession) {
            this.uploadStatus.put("finished", Boolean.TRUE);
        }
        return this.parts;
    }

    private void parseMultiPart(TokenStream ts, String boundary) throws IOException, MultipartException {
        ts.setBoundary(boundary.getBytes());
        ts.read();
        ts.setBoundary(("\r\n" + boundary).getBytes());
        while (ts.getState() == -2) {
            ts.nextPart();
            this.parsePart(ts);
        }
        if (ts.getState() != -3) {
            throw new MultipartException("Malformed stream");
        }
    }

    private void parsePart(TokenStream ts) throws IOException, MultipartException {
        block9: {
            Hashtable headers = new Hashtable();
            headers = this.readHeaders(ts);
            try {
                if (headers.containsKey("filename")) {
                    if (!"".equals(headers.get("filename"))) {
                        this.parseFilePart(ts, headers);
                    } else {
                        byte[] buf = new byte[32];
                        while (ts.getState() == -5) {
                            ts.read(buf);
                        }
                    }
                    break block9;
                }
                if (((String)headers.get("content-disposition")).toLowerCase().equals("form-data")) {
                    this.parseInlinePart(ts, headers);
                    break block9;
                }
                if (((String)headers.get("content-disposition")).toLowerCase().indexOf("multipart") > -1) {
                    this.parseMultiPart(new TokenStream(ts, 128), "--" + (String)headers.get("boundary"));
                    ts.read();
                    break block9;
                }
                throw new MultipartException("Unknown part type");
            }
            catch (IOException e) {
                throw new MultipartException("Malformed stream: " + e.getMessage());
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                throw new MultipartException("Malformed header");
            }
        }
    }

    private void parseFilePart(TokenStream in, Hashtable headers) throws IOException, MultipartException {
        OutputStream out;
        byte[] buf = new byte[4096];
        File file = null;
        if (this.oversized) {
            out = new NullOutputStream();
        } else if (!this.saveUploadedFilesToDisk) {
            out = new ByteArrayOutputStream();
        } else {
            String fileName = (String)headers.get("filename");
            fileName = File.separatorChar == '\\' ? fileName.replace('/', '\\') : fileName.replace('\\', '/');
            String filePath = this.uploadDirectory.getPath() + File.separator;
            fileName = new File(fileName).getName();
            file = new File(filePath + fileName);
            if (!this.allowOverwrite && !file.createNewFile()) {
                if (this.silentlyRename) {
                    int c = 0;
                    while (!(file = new File(filePath + c++ + "_" + fileName)).createNewFile()) {
                    }
                } else {
                    throw new MultipartException("Duplicate file '" + file.getName() + "' in '" + file.getParent() + "'");
                }
            }
            out = new FileOutputStream(file);
        }
        if (this.hasSession) {
            this.uploadStatus.put("finished", Boolean.FALSE);
            this.uploadStatus.put("started", Boolean.TRUE);
            this.uploadStatus.put("widget", headers.get("name"));
            this.uploadStatus.put("filename", headers.get("filename"));
        }
        int length = 0;
        try {
            int read = 0;
            while (in.getState() == -5) {
                read = in.read(buf);
                length += read;
                out.write(buf, 0, read);
                if (!this.hasSession) continue;
                this.uploadStatus.put("sent", new Integer((Integer)this.uploadStatus.get("sent") + read));
            }
            if (this.hasSession) {
                this.uploadStatus.put("uploadsdone", new Integer((Integer)this.uploadStatus.get("uploadsdone") + 1));
                this.uploadStatus.put("error", Boolean.FALSE);
            }
        }
        catch (IOException ioe) {
            out.close();
            out = null;
            if (file != null) {
                file.delete();
            }
            if (this.hasSession) {
                this.uploadStatus.put("error", Boolean.TRUE);
            }
            throw ioe;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        String name = (String)headers.get("name");
        if (this.oversized) {
            this.parts.put(name, new RejectedPart(headers, length, this.contentLength, this.maxUploadSize));
        } else if (file == null) {
            byte[] bytes = ((ByteArrayOutputStream)out).toByteArray();
            this.parts.put(name, new PartInMemory(headers, new ByteArrayInputStream(bytes), bytes.length));
        } else {
            this.parts.put(name, new PartOnDisk(headers, file));
        }
    }

    private void parseInlinePart(TokenStream in, Hashtable headers) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while (in.getState() == -5) {
            int c = in.read();
            if (c == -1) continue;
            bos.write(c);
        }
        String field = (String)headers.get("name");
        Vector<String> v = (Vector<String>)this.parts.get(field);
        if (v == null) {
            v = new Vector<String>();
            this.parts.put(field, v);
        }
        v.add(new String(bos.toByteArray(), this.characterEncoding));
    }

    private Hashtable readHeaders(TokenStream in) throws IOException {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        String hdrline = this.readln(in);
        while (!"".equals(hdrline)) {
            StringTokenizer tokenizer = new StringTokenizer(hdrline);
            headers.put(tokenizer.nextToken(" :").toLowerCase(), tokenizer.nextToken(" :;"));
            while (tokenizer.hasMoreTokens()) {
                headers.put(tokenizer.nextToken(" ;=\""), tokenizer.hasMoreTokens() ? tokenizer.nextToken("=\"") : "");
            }
            hdrline = this.readln(in);
        }
        return headers;
    }

    private String getBoundary(String hdr) {
        int start = hdr.toLowerCase().indexOf("boundary=");
        if (start > -1) {
            return "--" + hdr.substring(start + 9);
        }
        return null;
    }

    private String readln(TokenStream in) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int b = in.read();
        while (b != -1 && b != 13) {
            bos.write(b);
            b = in.read();
        }
        if (b == 13) {
            in.read();
        }
        return new String(bos.toByteArray(), this.characterEncoding);
    }
}

