/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.notification.Notifying;
import org.apache.cocoon.components.notification.NotifyingBuilder;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.HandleErrorsNode;
import org.apache.cocoon.environment.Environment;

public class ErrorHandlerHelper
extends AbstractLogEnabled
implements Composable {
    private ComponentManager manager;
    protected Logger handledErrorsLogger;
    private HandleErrorsNode error404;
    private HandleErrorsNode error500;

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.handledErrorsLogger = logger.getChildLogger("handled-errors");
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    void set404Handler(ProcessingNode node) {
        this.error404 = (HandleErrorsNode)node;
    }

    void set500Handler(ProcessingNode node) {
        this.error500 = (HandleErrorsNode)node;
    }

    public boolean isEmpty() {
        return this.error404 == null && this.error500 == null;
    }

    public boolean isInternal() {
        return this.error500 != null && this.error500.isInternal();
    }

    public boolean isExternal() {
        return this.error500 != null && this.error500.isExternal();
    }

    public boolean invokeErrorHandler(Exception ex, Environment env, InvokeContext context) throws Exception {
        return this.prepareErrorHandler(ex, env, context) != null;
    }

    public ProcessingPipeline prepareErrorHandler(Exception ex, Environment env, InvokeContext context) throws Exception {
        boolean internal;
        boolean bl = internal = !env.isExternal() && !env.isInternalRedirect();
        if (internal && !this.isInternal()) {
            throw ex;
        }
        if (!internal && !this.isExternal()) {
            throw ex;
        }
        if (!internal && this.error404 != null && ex instanceof ResourceNotFoundException) {
            return this.prepareErrorHandler(this.error404, ex, env, context);
        }
        if (this.error500 != null) {
            return this.prepareErrorHandler(this.error500, ex, env, context);
        }
        throw ex;
    }

    public boolean invokeErrorHandler(ProcessingNode node, Exception ex, Environment env, InvokeContext context) throws Exception {
        return this.prepareErrorHandler(node, ex, env, context) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProcessingPipeline prepareErrorHandler(ProcessingNode node, Exception ex, Environment env, InvokeContext context) throws Exception {
        if (ex instanceof ResourceNotFoundException) {
            this.handledErrorsLogger.error(ex.getMessage());
        } else {
            this.handledErrorsLogger.error(ex.getMessage(), (Throwable)ex);
        }
        try {
            this.prepare(context, env, ex);
            InvokeContext errorContext = new InvokeContext(context.isBuildingPipelineOnly());
            errorContext.enableLogging(this.getLogger());
            errorContext.setRedirector(context.getRedirector());
            errorContext.compose(this.manager);
            try {
                if (!node.invoke(env, errorContext)) throw ex;
                ProcessingPipeline processingPipeline = errorContext.getProcessingPipeline();
                return processingPipeline;
            }
            finally {
                errorContext.dispose();
            }
        }
        catch (Exception e) {
            this.getLogger().error("An exception occured while handling errors at " + node.getLocation(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare(InvokeContext context, Environment env, Exception ex) throws IOException, ComponentException {
        Map objectModel = env.getObjectModel();
        if (objectModel.get("notifying-object") == null) {
            if (!context.isBuildingPipelineOnly()) {
                env.tryResetResponse();
            }
            NotifyingBuilder notifyingBuilder = (NotifyingBuilder)this.manager.lookup(NotifyingBuilder.ROLE);
            Notifying currentNotifying = null;
            try {
                currentNotifying = notifyingBuilder.build((Object)this, ex);
            }
            finally {
                this.manager.release((Component)notifyingBuilder);
            }
            objectModel.put("notifying-object", currentNotifying);
            objectModel.put("throwable", ex);
        }
    }
}

