/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.thread;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.thread.DefaultThreadFactory;
import org.apache.cocoon.components.thread.DefaultThreadPool;
import org.apache.cocoon.components.thread.RunnableManager;
import org.apache.cocoon.components.thread.ThreadFactory;
import org.apache.cocoon.components.thread.ThreadPool;

public class DefaultRunnableManager
extends AbstractLogEnabled
implements RunnableManager,
Configurable,
Disposable,
Runnable,
Startable,
ThreadSafe {
    public static final String DEFAULT_THREAD_FACTORY = DefaultThreadFactory.class.getName();
    public static final int DEFAULT_QUEUE_SIZE = -1;
    public static final int DEFAULT_MAX_POOL_SIZE = 5;
    public static final int DEFAULT_MIN_POOL_SIZE = 5;
    public static final String DEFAULT_THREAD_PRIORITY = "NORM";
    public static final boolean DEFAULT_DAEMON_MODE = false;
    public static final long DEFAULT_KEEP_ALIVE_TIME = 60000L;
    public static final boolean DEFAULT_SHUTDOWN_GRACEFUL = false;
    public static final int DEFAULT_SHUTDOWN_WAIT_TIME = -1;
    public static final String DEFAULT_THREADPOOL_NAME = "default";
    protected SortedSet m_commandStack = new TreeSet();
    final Map m_pools = new HashMap();
    private Class m_defaultThreadFactoryClass;
    private boolean m_keepRunning = false;

    public void configure(Configuration config) throws ConfigurationException {
        String defaultThreadFactoryName = config.getChild("thread-factory").getValue(DEFAULT_THREAD_FACTORY);
        try {
            this.m_defaultThreadFactoryClass = Thread.currentThread().getContextClassLoader().loadClass(defaultThreadFactoryName);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Cannot create instance of default thread factory " + defaultThreadFactoryName, (Throwable)ex);
        }
        Configuration[] threadpools = config.getChild("thread-pools").getChildren("thread-pool");
        for (int i = 0; i < threadpools.length; ++i) {
            DefaultThreadPool pool = this.configThreadPool(threadpools[i]);
        }
        ThreadPool defaultThreadPool = (ThreadPool)this.m_pools.get(DEFAULT_THREADPOOL_NAME);
        if (null == defaultThreadPool) {
            this.createPool(DEFAULT_THREADPOOL_NAME, -1, 5, 5, this.getPriority(DEFAULT_THREAD_PRIORITY), false, 60000L, "RUN", false, -1);
        }
    }

    public void createPool(String name, int queueSize, int maxPoolSize, int minPoolSize, int priority, boolean isDaemon, long keepAliveTime, String blockPolicy, boolean shutdownGraceful, int shutdownWaitTime) {
        if (null != this.m_pools.get(name)) {
            throw new IllegalArgumentException("ThreadPool \"" + name + "\" already exists");
        }
        this.createPool(new DefaultThreadPool(), name, queueSize, maxPoolSize, minPoolSize, priority, isDaemon, keepAliveTime, blockPolicy, shutdownGraceful, shutdownWaitTime);
    }

    public ThreadPool createPool(int queueSize, int maxPoolSize, int minPoolSize, int priority, boolean isDaemon, long keepAliveTime, String blockPolicy, boolean shutdownGraceful, int shutdownWaitTime) {
        DefaultThreadPool pool = new DefaultThreadPool();
        String name = "anon-" + pool.hashCode();
        return this.createPool(pool, name, queueSize, maxPoolSize, minPoolSize, priority, isDaemon, keepAliveTime, blockPolicy, shutdownGraceful, shutdownWaitTime);
    }

    public void dispose() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Disposing all thread pools");
        }
        Iterator i = this.m_pools.keySet().iterator();
        while (i.hasNext()) {
            String poolName = (String)i.next();
            DefaultThreadPool pool = (DefaultThreadPool)this.m_pools.get(poolName);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Disposing thread pool " + pool.getName());
            }
            pool.shutdown();
            if (!this.getLogger().isDebugEnabled()) continue;
            this.getLogger().debug("Thread pool " + pool.getName() + " disposed");
        }
        try {
            this.m_pools.clear();
        }
        catch (Throwable t) {
            this.getLogger().error("Cannot dispose", t);
        }
    }

    public void execute(String threadPoolName, Runnable command, long delay, long interval) {
        if (delay < 0L) {
            throw new IllegalArgumentException("delay < 0");
        }
        if (interval < 0L) {
            throw new IllegalArgumentException("interval < 0");
        }
        ThreadPool pool = (ThreadPool)this.m_pools.get(threadPoolName);
        if (null == pool) {
            this.getLogger().warn("ThreadPool \"" + threadPoolName + "\" is not known. Will use ThreadPool \"" + DEFAULT_THREADPOOL_NAME + "\"");
            pool = (ThreadPool)this.m_pools.get(DEFAULT_THREADPOOL_NAME);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Command entered: " + command.toString() + ", pool=" + pool.getName() + ", delay=" + delay + ", interval=" + interval);
        }
        new ExecutionInfo(pool, command, delay, interval, this.getLogger());
    }

    public void execute(Runnable command, long delay, long interval) {
        this.execute(DEFAULT_THREADPOOL_NAME, command, delay, interval);
    }

    public void execute(Runnable command, long delay) {
        this.execute(DEFAULT_THREADPOOL_NAME, command, delay, 0L);
    }

    public void execute(Runnable command) {
        this.execute(DEFAULT_THREADPOOL_NAME, command, 0L, 0L);
    }

    public void execute(String threadPoolName, Runnable command, long delay) {
        this.execute(threadPoolName, command, delay, 0L);
    }

    public void execute(String threadPoolName, Runnable command) {
        this.execute(threadPoolName, command, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Runnable command) {
        SortedSet sortedSet = this.m_commandStack;
        synchronized (sortedSet) {
            Iterator i = this.m_commandStack.iterator();
            while (i.hasNext()) {
                ExecutionInfo info = (ExecutionInfo)i.next();
                if (info.m_command != command) continue;
                i.remove();
                this.m_commandStack.notifyAll();
                return;
            }
        }
        this.getLogger().warn("Could not find command " + command + " for removal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Entering loop");
        }
        while (this.m_keepRunning) {
            SortedSet sortedSet = this.m_commandStack;
            synchronized (sortedSet) {
                long delay;
                ExecutionInfo info;
                block14: {
                    try {
                        if (this.m_commandStack.size() > 0) {
                            info = (ExecutionInfo)this.m_commandStack.first();
                            delay = info.m_nextRun - System.currentTimeMillis();
                            if (delay > 0L) {
                                this.m_commandStack.wait(delay);
                            }
                        } else {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("No commands available. Will just wait for one");
                            }
                            this.m_commandStack.wait();
                        }
                    }
                    catch (InterruptedException ie) {
                        if (!this.getLogger().isDebugEnabled()) break block14;
                        this.getLogger().debug("I've been interrupted");
                    }
                }
                if (this.m_keepRunning && this.m_commandStack.size() > 0) {
                    info = (ExecutionInfo)this.m_commandStack.first();
                    delay = info.m_nextRun - System.currentTimeMillis();
                    if (delay < 0L) {
                        info.execute();
                    }
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Exiting loop");
        }
    }

    public void start() throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting the heart");
        }
        this.m_keepRunning = true;
        ((ThreadPool)this.m_pools.get(DEFAULT_THREADPOOL_NAME)).execute(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        this.m_keepRunning = false;
        SortedSet sortedSet = this.m_commandStack;
        synchronized (sortedSet) {
            this.m_commandStack.notifyAll();
        }
    }

    private int getPriority(String priority) {
        if ("MIN".equalsIgnoreCase(priority)) {
            return 1;
        }
        if (DEFAULT_THREAD_PRIORITY.equalsIgnoreCase(priority)) {
            return 5;
        }
        if ("MAX".equalsIgnoreCase(priority)) {
            return 10;
        }
        this.getLogger().warn("Unknown thread priority \"" + priority + "\". Set to \"NORM\".");
        return 5;
    }

    private DefaultThreadPool configThreadPool(Configuration config) throws ConfigurationException {
        String name = config.getChild("name").getValue();
        int queueSize = config.getChild("queue-size").getValueAsInteger(-1);
        int maxPoolSize = config.getChild("max-pool-size").getValueAsInteger(5);
        int minPoolSize = config.getChild("min-pool-size").getValueAsInteger(5);
        if (DEFAULT_THREADPOOL_NAME.equals(name) && minPoolSize > 0 && minPoolSize < 5) {
            minPoolSize = 5;
        }
        String priority = config.getChild("priority").getValue(DEFAULT_THREAD_PRIORITY);
        boolean isDaemon = config.getChild("daemon").getValueAsBoolean(false);
        long keepAliveTime = config.getChild("keep-alive-time-ms").getValueAsLong(60000L);
        String blockPolicy = config.getChild("block-policy").getValue("RUN");
        boolean shutdownGraceful = config.getChild("shutdown-graceful").getValueAsBoolean(false);
        int shutdownWaitTime = config.getChild("shutdown-wait-time-ms").getValueAsInteger(-1);
        return this.createPool(new DefaultThreadPool(), name, queueSize, maxPoolSize, minPoolSize, this.getPriority(priority), isDaemon, keepAliveTime, blockPolicy, shutdownGraceful, shutdownWaitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultThreadPool createPool(DefaultThreadPool pool, String name, int queueSize, int maxPoolSize, int minPoolSize, int priority, boolean isDaemon, long keepAliveTime, String blockPolicy, boolean shutdownGraceful, int shutdownWaitTime) {
        pool.enableLogging(this.getLogger().getChildLogger(name));
        pool.setName(name);
        ThreadFactory factory = null;
        try {
            factory = (ThreadFactory)this.m_defaultThreadFactoryClass.newInstance();
        }
        catch (Exception ex) {
            this.getLogger().warn("Cannot instantiate a ThreadFactory from class " + this.m_defaultThreadFactoryClass.getName() + ". Will use a " + DefaultThreadFactory.class.getName(), (Throwable)ex);
            factory = new DefaultThreadFactory();
        }
        factory.setPriority(priority);
        factory.setDaemon(isDaemon);
        pool.setThreadFactory(factory);
        pool.setQueue(queueSize);
        pool.setMaximumPoolSize(maxPoolSize < 0 ? Integer.MAX_VALUE : maxPoolSize);
        if (minPoolSize < 1) {
            this.getLogger().warn("min-pool-size < 1 for pool \"" + name + "\". Set to 1");
        }
        pool.setMinimumPoolSize(minPoolSize < 1 ? 1 : minPoolSize);
        if (keepAliveTime < 0L) {
            this.getLogger().warn("keep-alive-time-ms < 0 for pool \"" + name + "\". Set to 1000");
        }
        pool.setKeepAliveTime(keepAliveTime < 0L ? 1000L : keepAliveTime);
        pool.setBlockPolicy(blockPolicy);
        pool.setShutdownGraceful(shutdownGraceful);
        pool.setShutdownWaitTimeMs(shutdownWaitTime);
        Map map = this.m_pools;
        synchronized (map) {
            this.m_pools.put(name, pool);
        }
        this.printPoolInfo(pool);
        return pool;
    }

    private void printPoolInfo(DefaultThreadPool pool) {
        if (this.getLogger().isInfoEnabled()) {
            if (pool.isQueued()) {
                StringBuffer msg = new StringBuffer();
                msg.append("ThreadPool named \"").append(pool.getName());
                msg.append("\" created with maximum queue-size=");
                msg.append(pool.getMaxQueueSize());
                msg.append(",max-pool-size=").append(pool.getMaximumPoolSize());
                msg.append(",min-pool-size=").append(pool.getMinimumPoolSize());
                msg.append(",priority=").append(pool.getPriority());
                msg.append(",isDaemon=").append(((ThreadFactory)pool.getThreadFactory()).isDaemon());
                msg.append(",keep-alive-time-ms=").append(pool.getKeepAliveTime());
                msg.append(",block-policy=\"").append(pool.getBlockPolicy());
                msg.append("\",shutdown-wait-time-ms=").append(pool.getShutdownWaitTimeMs());
                this.getLogger().info(msg.toString());
            } else {
                StringBuffer msg = new StringBuffer();
                msg.append("ThreadPool named \"").append(pool.getName());
                msg.append("\" created with no queue,max-pool-size=").append(pool.getMaximumPoolSize());
                msg.append(",min-pool-size=").append(pool.getMinimumPoolSize());
                msg.append(",priority=").append(pool.getPriority());
                msg.append(",isDaemon=").append(((ThreadFactory)pool.getThreadFactory()).isDaemon());
                msg.append(",keep-alive-time-ms=").append(pool.getKeepAliveTime());
                msg.append(",block-policy=").append(pool.getBlockPolicy());
                msg.append(",shutdown-wait-time-ms=").append(pool.getShutdownWaitTimeMs());
                this.getLogger().info(msg.toString());
            }
        }
    }

    private class ExecutionInfo
    implements Comparable {
        final Logger m_logger;
        final Runnable m_command;
        final ThreadPool m_pool;
        final long m_delay;
        final long m_interval;
        long m_nextRun = 0L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ExecutionInfo(ThreadPool pool, Runnable command, long delay, long interval, Logger logger) {
            this.m_pool = pool;
            this.m_command = command;
            this.m_delay = delay;
            this.m_interval = interval;
            this.m_logger = logger;
            this.m_nextRun = System.currentTimeMillis() + delay;
            SortedSet sortedSet = DefaultRunnableManager.this.m_commandStack;
            synchronized (sortedSet) {
                DefaultRunnableManager.this.m_commandStack.add(this);
                DefaultRunnableManager.this.m_commandStack.notifyAll();
            }
            Thread.yield();
        }

        public int compareTo(Object other) {
            ExecutionInfo otherInfo = (ExecutionInfo)other;
            int diff = (int)(this.m_nextRun - otherInfo.m_nextRun);
            if (diff == 0) {
                if (this == other) {
                    return 0;
                }
                return System.identityHashCode(this) - System.identityHashCode(other);
            }
            return diff;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void execute() {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("Executing command " + this.m_command + " in pool \"" + this.m_pool.getName() + "\", schedule with interval=" + this.m_interval);
            }
            SortedSet sortedSet = DefaultRunnableManager.this.m_commandStack;
            synchronized (sortedSet) {
                DefaultRunnableManager.this.m_commandStack.remove(this);
                if (this.m_interval > 0L) {
                    this.m_nextRun = System.currentTimeMillis() + this.m_interval;
                    DefaultRunnableManager.this.m_commandStack.add(this);
                }
            }
            try {
                this.m_pool.execute(this.m_command);
            }
            catch (InterruptedException ie) {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("Interrupted executing command + " + this.m_command);
                }
            }
            catch (Throwable t) {
                this.m_logger.error("Exception executing command " + this.m_command, t);
            }
        }
    }
}

