/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.components.modules.output.OutputModule;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;

public class PropagatorAction
extends ServiceableAction
implements Configurable,
ThreadSafe {
    private static final String ACTION_PREFIX = "PropagatorAction:";
    private static final String CONFIG_STORE_EMPTY = "store-empty-parameters";
    private static final String CONFIG_OUTPUT_MODULE = "output-module";
    private static final String OUTPUT_HINT = "request-attr";
    private boolean storeEmpty = true;
    private Configuration outputConf;
    private String outputName;
    private List defaults;

    public void configure(Configuration config) throws ConfigurationException {
        this.outputConf = config.getChild(CONFIG_OUTPUT_MODULE);
        this.outputName = this.outputConf.getAttribute("name", OUTPUT_HINT);
        this.storeEmpty = config.getChild(CONFIG_STORE_EMPTY).getValueAsBoolean(this.storeEmpty);
        Configuration[] dflts = config.getChild("defaults").getChildren("default");
        if (dflts != null) {
            this.defaults = new ArrayList(dflts.length);
            for (int i = 0; i < dflts.length; ++i) {
                this.defaults.add(new Entry(dflts[i].getAttribute("name"), dflts[i].getAttribute("value")));
            }
        } else {
            this.defaults = new ArrayList(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        ServiceSelector selector;
        HashMap<String, String> results;
        block12: {
            String outputName = parameters.getParameter("PropagatorAction:output-module", null);
            boolean storeEmpty = parameters.getParameterAsBoolean("PropagatorAction:store-empty-parameters", this.storeEmpty);
            parameters.removeParameter("PropagatorAction:output-module");
            parameters.removeParameter("PropagatorAction:store-empty-parameters");
            Configuration outputConf = null;
            if (outputName == null) {
                outputName = this.outputName;
                outputConf = this.outputConf;
            }
            results = new HashMap<String, String>();
            OutputModule output = null;
            selector = null;
            try {
                try {
                    selector = (ServiceSelector)this.manager.lookup(OutputModule.ROLE + "Selector");
                    if (outputName != null && selector != null && selector.isSelectable((Object)outputName)) {
                        output = (OutputModule)selector.select((Object)outputName);
                        String[] names = parameters.getNames();
                        for (int i = 0; i < names.length; ++i) {
                            String name = names[i];
                            String value = parameters.getParameter(name);
                            if (!storeEmpty && (value == null || value.equals(""))) continue;
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Propagating <" + name + "> value <" + value + ">");
                            }
                            output.setAttribute(outputConf, objectModel, name, value);
                            results.put(name, value);
                        }
                        Iterator i = this.defaults.iterator();
                        while (i.hasNext()) {
                            Entry entry = (Entry)i.next();
                            if (results.containsKey(entry.key)) continue;
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Propagating default <" + entry.key + "> value <" + entry.value + ">");
                            }
                            output.setAttribute(outputConf, objectModel, entry.key, entry.value);
                            results.put(entry.key, entry.value);
                        }
                        output.commit(outputConf, objectModel);
                    }
                }
                catch (Exception e) {
                    if (output == null) throw e;
                    output.rollback(outputConf, objectModel, e);
                    throw e;
                }
                Object var17_18 = null;
                if (selector == null) return Collections.unmodifiableMap(results);
                if (output == null) break block12;
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                if (selector == null) throw throwable;
                if (output != null) {
                    selector.release((Object)output);
                }
                this.manager.release(selector);
                throw throwable;
            }
            selector.release((Object)output);
        }
        this.manager.release((Object)selector);
        return Collections.unmodifiableMap(results);
    }

    private static class Entry {
        public String key;
        public String value;

        public Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

