/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNExternal {
    private SVNRevision myRevision;
    private SVNRevision myPegRevision;
    private String myURL;
    private String myPath;
    private SVNURL myResolvedURL;
    private boolean myIsRevisionExplicit;
    private boolean myIsPegRevisionExplicit;
    private boolean myIsNewFormat;
    private String myRawValue;

    private SVNExternal() {
        this.myRevision = SVNRevision.UNDEFINED;
        this.myPegRevision = SVNRevision.UNDEFINED;
    }

    public SVNExternal(String target, String url, SVNRevision pegRevision, SVNRevision revision, boolean isRevisionExplicit, boolean isPegRevisionExplicit, boolean isNewFormat) {
        this.myPath = target;
        this.myURL = url;
        this.myRevision = revision;
        this.myPegRevision = pegRevision;
        this.myIsRevisionExplicit = isRevisionExplicit;
        this.myIsPegRevisionExplicit = isPegRevisionExplicit;
        this.myIsNewFormat = isNewFormat;
    }

    public SVNRevision getRevision() {
        return this.myRevision;
    }

    public SVNRevision getPegRevision() {
        return this.myPegRevision;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getUnresolvedUrl() {
        return this.myURL;
    }

    public String getRawValue() {
        return this.myRawValue;
    }

    public boolean isRevisionExplicit() {
        return this.myIsRevisionExplicit;
    }

    public boolean isPegRevisionExplicit() {
        return this.myIsPegRevisionExplicit;
    }

    public boolean isNewFormat() {
        return this.myIsNewFormat;
    }

    public SVNURL getResolvedURL() {
        return this.myResolvedURL;
    }

    public SVNURL resolveURL(SVNURL rootURL, SVNURL ownerURL) throws SVNException {
        SVNErrorMessage err;
        String canonicalURL = SVNPathUtil.canonicalizePath(this.myURL);
        if (SVNPathUtil.isURL(canonicalURL)) {
            this.myResolvedURL = SVNURL.parseURIEncoded(canonicalURL);
            return this.getResolvedURL();
        }
        if (this.myURL.startsWith("../") || this.myURL.startsWith("^/")) {
            String[] base = this.myURL.startsWith("../") ? ownerURL.getPath().split("/") : rootURL.getPath().split("/");
            LinkedList<String> baseList = new LinkedList<String>(Arrays.asList(base));
            if (canonicalURL.startsWith("^/")) {
                canonicalURL = canonicalURL.substring("^/".length());
            }
            String[] relative = canonicalURL.split("/");
            for (int i = 0; i < relative.length; ++i) {
                if ("..".equals(relative[i])) {
                    if (baseList.isEmpty()) continue;
                    baseList.removeLast();
                    continue;
                }
                baseList.add(relative[i]);
            }
            String finalPath = "/";
            Iterator segments = baseList.iterator();
            while (segments.hasNext()) {
                String segment = (String)segments.next();
                finalPath = SVNPathUtil.append(finalPath, segment);
            }
            this.myResolvedURL = ownerURL.setPath(finalPath, true);
            return this.getResolvedURL();
        }
        if (this.myURL.indexOf("/../") >= 0 || this.myURL.startsWith("../") || this.myURL.endsWith("/..")) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "The external relative URL ''{0}'' cannot have backpaths, i.e. ''..''.", this.myURL);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (this.myURL.startsWith("//")) {
            this.myResolvedURL = SVNURL.parseURIEncoded(SVNPathUtil.canonicalizePath(rootURL.getProtocol() + ":" + this.myURL));
            return this.getResolvedURL();
        }
        if (this.myURL.startsWith("/")) {
            this.myResolvedURL = ownerURL.setPath(this.myURL, true);
            return this.getResolvedURL();
        }
        err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Unrecognized format for the relative external URL ''{0}''.", this.myURL);
        SVNErrorManager.error(err, SVNLogType.DEFAULT);
        return null;
    }

    public String toString() {
        String value = "";
        if (this.myIsPegRevisionExplicit && SVNRevision.isValidRevisionNumber(this.myPegRevision.getNumber())) {
            if (this.myIsRevisionExplicit && SVNRevision.isValidRevisionNumber(this.myRevision.getNumber())) {
                value = value + "-r" + this.myRevision + " ";
            }
            value = value + this.myURL + "@" + this.myPegRevision + " " + this.myPath;
        } else if (this.myIsNewFormat) {
            if (this.myIsRevisionExplicit && SVNRevision.isValidRevisionNumber(this.myRevision.getNumber())) {
                value = value + "-r" + this.myRevision + " ";
            }
            value = value + this.myURL + " " + this.myPath;
        } else {
            value = value + this.myPath;
            if (this.myIsRevisionExplicit && SVNRevision.isValidRevisionNumber(this.myRevision.getNumber())) {
                value = value + " -r" + this.myRevision;
            }
            value = value + " " + this.myURL;
        }
        return value;
    }

    public static SVNExternal[] parseExternals(String owner, String description) throws SVNException {
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(description, "\r\n");
        while (tokenizer.hasMoreTokens()) {
            lines.add(tokenizer.nextToken());
        }
        ArrayList<SVNExternal> externals = new ArrayList<SVNExternal>();
        for (int i = 0; i < lines.size(); ++i) {
            SVNErrorMessage err;
            String line = ((String)lines.get(i)).trim();
            if ("".equals(line) || line.startsWith("#")) continue;
            ArrayList tokens = new ArrayList();
            ExternalTokenizer tokenizer2 = new ExternalTokenizer(line);
            while (tokenizer2.hasNext()) {
                tokens.add(tokenizer2.next());
            }
            if (tokens.size() < 2 || tokens.size() > 4) {
                SVNExternal.reportParsingError(owner, line);
            }
            SVNExternal external = new SVNExternal();
            int revisionToken = SVNExternal.fetchRevision(external, owner, line, tokens);
            String token0 = (String)tokens.get(0);
            String token1 = (String)tokens.get(1);
            boolean token0isURL = SVNPathUtil.isURL(token0);
            boolean token1isURL = SVNPathUtil.isURL(token1);
            if (token0isURL && token1isURL) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_EXTERNALS_DESCRIPTION, "Invalid svn:external property on ''{0}'': cannot use two absolute URLs (''{1}'' and ''{2}'') in an external; one must be a path where an absolute or relative URL is checked out to", new Object[]{owner, token0, token1});
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (revisionToken == 0 && token1isURL) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_EXTERNALS_DESCRIPTION, "Invalid svn:external property on ''{0}'': cannot use a URL ''{1}'' as the target directory for an external definition", new Object[]{owner, token1});
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (revisionToken == 1 && token0isURL) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_EXTERNALS_DESCRIPTION, "Invalid svn:external property on ''{0}'': cannot use a URL ''{1}'' as the target directory for an external definition", new Object[]{owner, token0});
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (revisionToken == 0 || revisionToken == -1 && (token0isURL || !token1isURL)) {
                external.myPath = token1;
                boolean schemeRelative = token0.startsWith("//");
                if (schemeRelative) {
                    token0 = token0.substring(2);
                }
                SVNPath path = new SVNPath(token0, true);
                external.myURL = schemeRelative ? "//" + path.getTarget() : path.getTarget();
                external.myPegRevision = path.getPegRevision();
                if (external.myPegRevision == SVNRevision.BASE) {
                    external.myPegRevision = SVNRevision.HEAD;
                }
                if (external.myPegRevision != SVNRevision.UNDEFINED) {
                    external.myIsPegRevisionExplicit = true;
                }
                external.myIsNewFormat = true;
            } else {
                external.myPath = token0;
                external.myURL = token1;
                external.myPegRevision = external.myRevision;
            }
            if (external.myPegRevision == SVNRevision.UNDEFINED) {
                external.myPegRevision = SVNRevision.HEAD;
            }
            if (external.myRevision == SVNRevision.UNDEFINED) {
                external.myRevision = external.myPegRevision;
            }
            external.myPath = SVNPathUtil.canonicalizePath(external.myPath.replace(File.separatorChar, '/'));
            if (external.myPath.length() == 0 || external.myPath.startsWith("/") || external.myPath.indexOf("/../") > 0 || external.myPath.endsWith("/..")) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_EXTERNALS_DESCRIPTION, "Invalid {0} property on ''{1}'': target ''{2}'' is an absolute path or involves ''..''", new Object[]{"svn:externals", owner, external.myPath});
                SVNErrorManager.error(err2, SVNLogType.DEFAULT);
            }
            external.myRawValue = line;
            externals.add(external);
        }
        return externals.toArray(new SVNExternal[externals.size()]);
    }

    private static int fetchRevision(SVNExternal external, String owner, String line, List tokens) throws SVNException {
        for (int i = 0; i < tokens.size() && i < 2; ++i) {
            String token = (String)tokens.get(i);
            String revisionStr = null;
            if (token.length() < 2 || token.charAt(0) != '-' || token.charAt(1) != 'r') continue;
            if (token.length() == 2 && tokens.size() == 4) {
                revisionStr = (String)tokens.get(i + 1);
                tokens.remove(i);
            } else if (tokens.size() == 3) {
                revisionStr = token.substring(2);
            }
            if (revisionStr == null || "".equals(revisionStr)) {
                SVNExternal.reportParsingError(owner, line);
            }
            long revNumber = -1L;
            try {
                revNumber = Long.parseLong(revisionStr);
                if (revNumber < 0L) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "Negative revision number found parsing '" + revisionStr + "'");
                    SVNExternal.reportParsingError(owner, line);
                }
            }
            catch (NumberFormatException nfe) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "Invalid revision number found parsing '" + revisionStr + "'");
                SVNExternal.reportParsingError(owner, line);
            }
            external.myRevision = SVNRevision.create(revNumber);
            external.myIsRevisionExplicit = true;
            tokens.remove(i);
            return i;
        }
        if (tokens.size() == 2) {
            return -1;
        }
        SVNExternal.reportParsingError(owner, line);
        return -1;
    }

    private static void reportParsingError(String owner, String line) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_EXTERNALS_DESCRIPTION, "Error parsing {0} property on ''{1}'': ''{2}''", new Object[]{"svn:externals", owner, line});
        SVNErrorManager.error(err, SVNLogType.DEFAULT);
    }

    private static class ExternalTokenizer
    implements Iterator {
        private String myNextToken;
        private String myLine;

        public ExternalTokenizer(String line) {
            this.myLine = line;
            this.myNextToken = this.advance();
        }

        public boolean hasNext() {
            return this.myNextToken != null;
        }

        public Object next() {
            String next = this.myNextToken;
            this.myNextToken = this.advance();
            return next;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private String advance() {
            int quouteType;
            while (this.myLine.length() > 0 && Character.isWhitespace(this.myLine.charAt(0))) {
                this.myLine = this.myLine.substring(1);
            }
            if (this.myLine.length() == 0) {
                return null;
            }
            char ch = this.myLine.charAt(0);
            int n = ch == '\'' ? 1 : (quouteType = ch == '\"' ? 2 : 0);
            if (quouteType != 0) {
                this.myLine = this.myLine.substring(1);
            }
            int index = 0;
            while (index < this.myLine.length()) {
                ch = this.myLine.charAt(index);
                if (ch == '\\') {
                    ++index;
                    ++index;
                    continue;
                }
                if (quouteType == 0 ? Character.isWhitespace(ch) : (quouteType == 1 ? ch == '\'' : quouteType == 2 && ch == '\"')) break;
                ++index;
            }
            String token = this.myLine.substring(0, index);
            StringBuffer result = new StringBuffer();
            for (index = 0; index < token.length(); ++index) {
                ch = token.charAt(index);
                if (ch != '\\') {
                    result.append(ch);
                    continue;
                }
                if (index + 1 < token.length()) {
                    char escaped = token.charAt(index + 1);
                    if (escaped == 't') {
                        result.append("\t");
                    } else {
                        result.append(escaped);
                    }
                }
                ++index;
            }
            this.myLine = index + 1 < this.myLine.length() ? this.myLine.substring(index + 1) : "";
            return result.toString();
        }
    }
}

