/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import javax.net.ssl.X509TrustManager;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNSSLTrustManager
implements X509TrustManager {
    private SVNURL myURL;
    private DefaultSVNAuthenticationManager myAuthManager;
    private X509Certificate[] myTrustedCerts;
    private String myRealm;
    private File myAuthDirectory;
    private boolean myIsUseKeyStore;
    private File[] myServerCertFiles;

    public DefaultSVNSSLTrustManager(File authDir, SVNURL url, File[] serverCertFiles, boolean useKeyStore, DefaultSVNAuthenticationManager authManager) {
        this.myURL = url;
        this.myAuthDirectory = authDir;
        this.myRealm = "https://" + url.getHost() + ":" + url.getPort();
        this.myAuthManager = authManager;
        this.myIsUseKeyStore = useKeyStore;
        this.myServerCertFiles = serverCertFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ArrayList<X509Certificate> trustedCerts;
        block19: {
            if (this.myTrustedCerts != null) {
                return;
            }
            trustedCerts = new ArrayList<X509Certificate>();
            for (int i = 0; i < this.myServerCertFiles.length; ++i) {
                X509Certificate cert = DefaultSVNSSLTrustManager.loadCertificate(this.myServerCertFiles[i]);
                if (cert == null) continue;
                trustedCerts.add(cert);
            }
            if (this.myIsUseKeyStore) {
                try {
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    if (keyStore == null) break block19;
                    String path = System.getProperty("java.home") + "/lib/security/cacerts";
                    path = path.replace('/', File.separatorChar);
                    File file = new File(path);
                    InputStream is = null;
                    try {
                        if (file.isFile() && file.canRead()) {
                            is = SVNFileUtil.openFileForReading(file, SVNLogType.WC);
                        }
                        keyStore.load(is, null);
                    }
                    catch (NoSuchAlgorithmException e) {
                    }
                    catch (CertificateException e) {
                    }
                    catch (IOException e) {
                    }
                    catch (SVNException e) {
                    }
                    finally {
                        SVNFileUtil.closeFile(is);
                    }
                    PKIXParameters params = new PKIXParameters(keyStore);
                    Iterator<TrustAnchor> anchors = params.getTrustAnchors().iterator();
                    while (anchors.hasNext()) {
                        TrustAnchor ta = anchors.next();
                        X509Certificate cert = ta.getTrustedCert();
                        if (cert == null) continue;
                        trustedCerts.add(cert);
                    }
                }
                catch (KeyStoreException e) {
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    // empty catch block
                }
            }
        }
        this.myTrustedCerts = trustedCerts.toArray(new X509Certificate[trustedCerts.size()]);
    }

    public X509Certificate[] getAcceptedIssuers() {
        this.init();
        return this.myTrustedCerts;
    }

    public void checkClientTrusted(X509Certificate[] certs, String arg1) throws CertificateException {
    }

    public void checkServerTrusted(X509Certificate[] certs, String algorithm) throws CertificateException {
        if (certs != null && certs.length > 0 && certs[0] != null) {
            String stored;
            String data = SVNBase64.byteArrayToBase64(certs[0].getEncoded());
            if (data.equals(stored = (String)this.myAuthManager.getRuntimeAuthStorage().getData("svn.ssl.server", this.myRealm))) {
                return;
            }
            stored = this.getStoredServerCertificate(this.myRealm);
            if (data.equals(stored)) {
                return;
            }
            ISVNAuthenticationProvider authProvider = this.myAuthManager.getAuthenticationProvider();
            int failures = SVNSSLUtil.getServerCertificateFailures(certs[0], this.myURL.getHost());
            if (authProvider != null) {
                boolean store = this.myAuthManager.isAuthStorageEnabled();
                int result = authProvider.acceptServerAuthentication(this.myURL, this.myRealm, certs[0], store);
                if (result == 2 && store) {
                    try {
                        this.storeServerCertificate(this.myRealm, data, failures);
                    }
                    catch (SVNException e) {
                        throw new SVNSSLUtil.CertificateNotTrustedException("svn: Server SSL ceritificate for '" + this.myRealm + "' cannot be saved");
                    }
                }
                if (result != 0) {
                    this.myAuthManager.getRuntimeAuthStorage().putData("svn.ssl.server", this.myRealm, data);
                    return;
                }
                throw new SVNSSLUtil.CertificateNotTrustedException("svn: Server SSL ceritificate for '" + this.myRealm + "' rejected");
            }
            return;
        }
    }

    private String getStoredServerCertificate(String realm) {
        File file = new File(this.myAuthDirectory, SVNFileUtil.computeChecksum(realm));
        if (!file.isFile()) {
            return null;
        }
        SVNWCProperties props = new SVNWCProperties(file, "");
        try {
            String storedRealm = props.getPropertyValue("svn:realmstring");
            if (!realm.equals(storedRealm)) {
                return null;
            }
            return props.getPropertyValue("ascii_cert");
        }
        catch (SVNException e) {
            return null;
        }
    }

    private void storeServerCertificate(String realm, String data, int failures) throws SVNException {
        this.myAuthDirectory.mkdirs();
        File file = new File(this.myAuthDirectory, SVNFileUtil.computeChecksum(realm));
        SVNWCProperties props = new SVNWCProperties(file, "");
        props.delete();
        try {
            props.setPropertyValue("ascii_cert", data);
            props.setPropertyValue("svn:realmstring", realm);
            props.setPropertyValue("failures", Integer.toString(failures));
            SVNFileUtil.setReadonly(props.getFile(), false);
        }
        catch (SVNException e) {
            props.delete();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate loadCertificate(File pemFile) {
        InputStream is = null;
        try {
            is = SVNFileUtil.openFileForReading(pemFile, SVNLogType.WC);
        }
        catch (SVNException e) {
            return null;
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            X509Certificate x509Certificate = (X509Certificate)factory.generateCertificate(is);
            return x509Certificate;
        }
        catch (CertificateException e) {
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
    }
}

