/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.pipeline.AbstractTransformation;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.xml.xslt.XSLTProcessor;
import org.apache.excalibur.xml.xslt.XSLTProcessorException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public abstract class AbstractXSLTTransformation
extends AbstractTransformation {
    private XSLTProcessor xsltProcessor;
    private ModifiableSource inputSource;
    private TransformerHandler transformerHandler;

    public void configure(Configuration configuration) throws ConfigurationException {
        try {
            XSLTProcessor xsltProcessor;
            super.configure(configuration);
            String src = configuration.getAttribute("src");
            ConfigurationUtils.checkConfAttributeValue("src", src, configuration.getLocation());
            File srcFile = null;
            try {
                srcFile = Utilities.resolveFile(null, configuration.getLocation(), (Context)super.getContext(), src, false);
            }
            catch (SDXException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
            }
            src = srcFile.toURI().toURL().toExternalForm();
            this.xsltProcessor = xsltProcessor = (XSLTProcessor)this._manager.lookup(XSLTProcessor.ROLE);
            this.xsltProcessor.setTransformerFactory(this.getTransformerFactory());
            this.inputSource = (ModifiableSource)this._resolver.resolveURI(src);
        }
        catch (IOException e) {
            LoggingUtils.logException(super.getLog(), e);
            throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
        }
        catch (ServiceException e) {
            LoggingUtils.logException(super.getLog(), (Exception)((Object)e));
            throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
        }
    }

    public void setConsumer(XMLConsumer consumer) {
        try {
            Utilities.checkXmlConsumer(super.getLog(), consumer);
        }
        catch (SDXException e) {
            // empty catch block
        }
        this.inputSource.refresh();
        try {
            this.transformerHandler = this.xsltProcessor.getTransformerHandler((Source)this.inputSource);
            if (this.getParameters() != null) {
                Transformer trans = this.transformerHandler.getTransformer();
                trans.clearParameters();
                Parameters params = this.getParameters();
                String[] paramNames = params.getNames();
                for (int i = 0; i < paramNames.length; ++i) {
                    try {
                        trans.setParameter(paramNames[i], params.getParameter(paramNames[i]));
                        continue;
                    }
                    catch (ParameterException e) {
                        LoggingUtils.logException(super.getLog(), (Exception)((Object)e));
                    }
                }
            }
        }
        catch (XSLTProcessorException e) {
            LoggingUtils.logException(super.getLog(), (Exception)((Object)e));
        }
        super.setContentHandler((ContentHandler)this.transformerHandler);
        super.setLexicalHandler((LexicalHandler)this.transformerHandler);
        if (this.transformerHandler instanceof LogEnabled) {
            ((LogEnabled)this.transformerHandler).enableLogging(super.getLog());
        }
        SAXResult result = new SAXResult((ContentHandler)consumer);
        result.setLexicalHandler((LexicalHandler)consumer);
        if (this.transformerHandler != null) {
            this.transformerHandler.setResult(result);
        }
        this.xmlConsumer = consumer;
    }

    public void startDocument() throws SAXException {
        this.setConsumer(this.xmlConsumer);
        super.startDocument();
    }

    protected boolean initToSax() {
        if (!super.initToSax()) {
            return false;
        }
        this._xmlizable_objects.put("Name", this.getClass().getName());
        return true;
    }

    public abstract String getTransformerFactory();
}

