/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.oai;

import fr.gouv.culture.sdx.oai.BasicOAIMetadataFormat;
import fr.gouv.culture.sdx.utils.Utilities;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SDXOAIMetadataFormat
extends BasicOAIMetadataFormat {
    public static final String VERSION_PATH = "doc-sdx2";
    public static final String DEFAULT_SCHEMA_URL = "http://www.nongnu.org/sdx/docs/html/doc-sdx2/schemas/sdx-oai-metadata-format.xsd";

    public SDXOAIMetadataFormat() {
        this.formatName = "SDX Fields";
        this.prefix = "sdx";
        this.namespace = "http://www.culture.gouv.fr/ns/sdx/sdx";
        this.schemaUrl = DEFAULT_SCHEMA_URL;
        this.rootElement = this.prefix;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        if (configuration != null) {
            this.formatName = configuration.getAttribute("name", this.formatName);
            this.prefix = configuration.getAttribute("metadataPrefix", this.prefix);
            this.namespace = configuration.getAttribute("namespace", this.namespace);
            this.schemaUrl = configuration.getAttribute("schemaUrl", this.schemaUrl);
            this.rootElement = configuration.getAttribute("rootElement", this.rootElement);
            this.configureFields(configuration);
            this.configurePipeline(configuration);
        }
    }

    protected void configureFields(Configuration configuration) throws ConfigurationException {
        Configuration[] oaiFieldsConf;
        if (configuration != null && (oaiFieldsConf = configuration.getChild("oai-fields", true).getChildren("oai-field")).length > 0) {
            for (int i = 0; i < oaiFieldsConf.length; ++i) {
                Configuration oaiFieldConf = oaiFieldsConf[i];
                String sdxFieldName = oaiFieldConf.getAttribute("sdxField");
                String repeated = oaiFieldConf.getAttribute("repeated", "repeated");
                if (!"concatenate".equals(repeated)) continue;
                if (this.concatenateFields == null) {
                    this.concatenateFields = new Parameters();
                }
                String separator = oaiFieldConf.getAttribute("separator", this.DEFAULT_CONCATENATED_FIELD_SEPARATOR);
                this.concatenateFields.setParameter(sdxFieldName, separator);
            }
        }
    }

    protected void prepareAndSendElement(String origName, String value) throws SAXException {
        if (Utilities.checkString(this.namespace) && Utilities.checkString(this.prefix) && Utilities.checkString(origName) && Utilities.checkString(value)) {
            String uri = this.namespace;
            String locName = "field";
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "CDATA", origName);
            super.sendElement(uri, locName, locName, atts, value);
        }
    }
}

