/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.document;

import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.documentbase.DefaultIDGenerator;
import fr.gouv.culture.sdx.documentbase.IDGenerator;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.xml.sax.InputSource;

public abstract class AbstractDocument
extends AbstractSdxObject
implements Document {
    private static final int FROM_UNKNOWN = -1;
    private static final int FROM_FILE = 0;
    private static final int FROM_URL = 1;
    private static final int FROM_BYTE_ARRAY = 2;
    private static final int FROM_INPUT_STREAM = 3;
    private int origin = -1;
    private File cFile = null;
    private URL cURL = null;
    private InputStream cInputStream = null;
    private byte[] cByteArray = null;
    private String preferredFilename;
    protected String storeRepo = "";
    protected String mimeType;
    protected IDGenerator idGenerator = new DefaultIDGenerator();
    protected String idPrefix = "";
    protected String idSuffix = "";

    public InputStream openStream() throws SDXException {
        switch (this.origin) {
            case 0: {
                try {
                    return new FileInputStream(this.cFile);
                }
                catch (FileNotFoundException e) {
                    String[] args = new String[]{this.getId(), this.cFile.getAbsolutePath()};
                    throw new SDXException(super.getLog(), 5005, args, e);
                }
            }
            case 1: {
                try {
                    if (this.cURL != null) {
                        return this.cURL.openStream();
                    }
                    return null;
                }
                catch (IOException e) {
                    String[] args = new String[]{this.getId(), this.cURL.toExternalForm()};
                    throw new SDXException(super.getLog(), 5005, args, e);
                }
            }
            case 2: {
                return new ByteArrayInputStream(this.cByteArray);
            }
            case 3: {
                return this.cInputStream;
            }
        }
        String[] args = new String[]{this.getId(), "inputStream"};
        throw new SDXException(super.getLog(), 5005, args, null);
    }

    protected InputSource getInputSource() throws SDXException {
        InputSource source = null;
        switch (this.origin) {
            case 0: {
                try {
                    source = new InputSource(this.cFile.toURI().toURL().toString());
                    break;
                }
                catch (MalformedURLException e) {
                    String[] args = new String[]{this.cFile.getAbsolutePath(), e.getMessage()};
                    throw new SDXException(super.getLog(), 5002, args, e);
                }
            }
            case 1: {
                try {
                    source = new InputSource(this.cURL.toExternalForm());
                    break;
                }
                catch (Exception e) {
                    String[] args = new String[]{this.cURL.toExternalForm(), e.getMessage()};
                    throw new SDXException(super.getLog(), 5002, args, e);
                }
            }
            case 3: {
                source = new InputSource(this.openStream());
                break;
            }
            case 2: {
                source = new InputSource(this.openStream());
                break;
            }
            default: {
                source = new InputSource(this.openStream());
            }
        }
        return source;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setContent(byte[] b) {
        this.cByteArray = b;
        this.resetContent(2);
    }

    public void setContent(File f) {
        this.cFile = f;
        this.resetContent(0);
    }

    public void setContent(URL u) {
        this.cURL = u;
        this.resetContent(1);
    }

    public void setContent(InputStream is) {
        this.cInputStream = is;
        this.resetContent(3);
    }

    public void save(Repository r) throws SDXException {
        RepositoryConnection c = r.getConnection();
        r.add(this, c);
        c.commit();
        r.releaseConnection(c);
    }

    private void resetContent(int newOrigin) {
        switch (newOrigin) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.cFile = null;
                this.cURL = null;
                this.cByteArray = null;
                this.cInputStream = null;
            }
        }
        this.origin = newOrigin;
        this.setPreferredFilename();
    }

    public int getLength() {
        switch (this.origin) {
            case 0: {
                if (this.cFile != null) {
                    return (int)this.cFile.length();
                }
                return 0;
            }
            case 1: {
                if (this.cURL != null) {
                    int ret = 0;
                    try {
                        URLConnection conn = this.cURL.openConnection();
                        ret = conn.getContentLength();
                        conn = null;
                    }
                    catch (IOException e) {
                        ret = 0;
                        String[] args = new String[]{this.cURL.toExternalForm(), e.getMessage()};
                        new SDXException(super.getLog(), 5003, args, e);
                        ret = 0;
                    }
                    return ret;
                }
                return 0;
            }
            case 2: {
                if (this.cByteArray != null) {
                    return this.cByteArray.length;
                }
                return 0;
            }
            case 3: {
                if (this.cInputStream != null) {
                    try {
                        return this.cInputStream.available();
                    }
                    catch (IOException e) {
                        String[] args = new String[]{this.cInputStream.toString(), e.getMessage()};
                        new SDXException(super.getLog(), 5002, args, e);
                        return 0;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public String getPreferredFilename() {
        return this.preferredFilename;
    }

    protected void setPreferredFilename() {
        String filename = null;
        switch (this.origin) {
            case 0: {
                if (this.cFile == null) break;
                filename = this.cFile.getName();
                break;
            }
            case 1: {
                if (this.cURL == null) break;
                filename = this.cURL.getFile().substring(this.cURL.getFile().lastIndexOf("/") + 1);
            }
        }
        this.setPreferredFilename(filename);
    }

    public URL getURL() throws SDXException {
        switch (this.origin) {
            case 1: {
                return this.cURL;
            }
            case 0: {
                if (this.cFile != null) {
                    try {
                        if (this.cURL != null) {
                            return this.cURL;
                        }
                        return this.cFile.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        String[] args = new String[]{this.getId(), this.cFile.getAbsolutePath()};
                        throw new SDXException(super.getLog(), 5004, args, e);
                    }
                }
                return null;
            }
        }
        if (this.cURL != null) {
            return this.cURL;
        }
        return null;
    }

    public void setURL(URL url) {
        this.cURL = url;
    }

    public void setPreferredFilename(String filename) {
        this.preferredFilename = filename;
    }

    public void setIdGenerator(IDGenerator idGen) {
        this.setIdGenerator(idGen, null, null);
    }

    public void setIdGenerator(IDGenerator idGen, String idPrefix, String idSuffix) {
        this.idGenerator = idGen;
        this.idPrefix = idPrefix;
        this.idSuffix = idSuffix;
    }

    public String getRepositoryForStorage() {
        return this.storeRepo;
    }

    public void setRepositoryForStorage(String repoId) {
        this.storeRepo = repoId;
    }

    protected String getClassNameSuffix() {
        return "Document";
    }

    protected boolean initToSax() {
        return true;
    }

    protected void initVolatileObjectsToSax() {
    }
}

